<?php

namespace App\Actions;

use App\Models\Activation;
use App\Models\Product;
use Http;

class RemoteDeactivate {
    public static function handle( Activation $activation, Product $product ): void {
        if ( $activation->post_url != '' ) {
            $request = [];

            list( $requestData, $response, $signature ) = sign( $request, $product->private_key, $product->passphrase, $product->algorithm );

            Http::withoutVerifying()->asForm()->post( $activation->post_url, [
                'response'        => $requestData,
                'response_base64' => $response,
                'signature'       => $signature
            ] );
        }
    }
}
