<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class Installed {
	/**
	 * Handle an incoming request.
	 *
	 * @param Request $request
	 * @param Closure(Request): (Response) $next
	 *
	 * @return Response
	 */
	public function handle( Request $request, Closure $next ): Response {
		if ( ! file_exists( storage_path( 'installed' ) ) ) {
			return redirect()->route( 'LaravelInstaller::welcome' );
		}

		return $next( $request );
	}
}
