<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class UserCan {
    /**
     * Handle an incoming request.
     *
     * @param Request $request
     * @param Closure(Request): (Response) $next
     *
     * @return Response
     */
    public function handle( Request $request, Closure $next ): Response {
        if ( ! can( $request->route()->getName() ) ) {
            abort( 403, __( 'Access denied' ) );
        }

        return $next( $request );
    }
}
