<?php

namespace App\Models;

use App\Traits\Excludable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Downloadable extends Model {
    use Excludable;

    protected array $dates = [ 'release_date', 'assigned_after', 'assigned_before', 'expires_before', 'accessible_until' ];

    public function product(): BelongsTo {
        return $this->belongsTo( Product::class );
    }
}
