<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Generator extends Model {
    public function product(): BelongsTo {
        return $this->belongsTo( Product::class );
    }

    public static function getMethods(): array {
        return [
            'uuid'         => [
                'text'  => __( 'UUID' ),
                'class' => 'success'
            ],
            'chunk-system' => [
                'text'  => __( 'Chunk System' ),
                'class' => 'success'
            ],
            'custom'       => [
                'text'  => __( 'Custom Function' ),
                'class' => 'success'
            ],
        ];
    }
}
