<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Telemetry extends Model {
    protected $table = 'telemetry';
    public static array $dataTypes = [ 'numeric-xy-axis', 'numeric-single-value', 'text' ];

    protected $fillable = [ 'product_id', 'user_identifier', 'license_key', 'activation_identifier', 'product_version', 'data_type', 'data_group', 'data' ];

    public function product(): BelongsTo {
        return $this->belongsTo( Product::class );
    }
}
