<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;


class User extends Authenticatable {
    use HasFactory, Notifiable;

    protected $hidden = [
        'password',
        'remember_token',
    ];

    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    public function getFormattedRole() {
        return User::getRoles()[ $this->role ];
    }

    public static function getRoles(): array {
        return [
            'admin'   => __( 'Administrator' ),
            'manager' => __( 'Manager' ),
        ];
    }

    public function getCapabilities(): array {
        $common_capabilities = [ 'toasts', 'auth.logout', 'json-products' ];

        if ( $this->role == 'manager' ) {
            return array_merge( $common_capabilities, [ 'dashboard', 'license-keys', 'generators', 'products', 'activations', 'downloadables' ] );
        } else if ( $this->role == 'admin' ) {
            return array_merge( $common_capabilities, [ 'dashboard', 'license-keys', 'generators', 'products', 'activations', 'downloadables', 'settings', 'telemetry', 'logs', 'users', 'api-keys' ] );
        }

        return [];
    }
}
