<?php

namespace App\Providers;

use App\Models\Setting;
use App\Services\Log;
use Illuminate\Pagination\Paginator;
use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider {
	/**
	 * Register any application services.
	 *
	 * @return void
	 */
	public function register() {
		//
	}

	/**
	 * Bootstrap any application services.
	 *
	 * @return void
	 */
	public function boot() {
		autoMigrate();

		$language = \Config::get( 'app.locale' );
		config( [ 'lang' => $language, 'langDirection' => getLangDirection( $language ) ] );
		Log::actions();
		
		Paginator::useBootstrapFive();
	}
}
