<?php

namespace App\Rules;

use Closure;
use Illuminate\Contracts\Validation\ValidationRule;
use Illuminate\Support\Facades\Request;
use Illuminate\Translation\PotentiallyTranslatedString;

class ValidPurchaseCode implements ValidationRule {
	/**
	 * Run the validation rule.
	 *
	 * @param string $attribute
	 * @param mixed $value
	 * @param Closure(string): PotentiallyTranslatedString $fail
	 */
	public function validate( string $attribute, mixed $value, Closure $fail ): void {
		if ( ! isEnvatoPurchaseCode( $value ) ) {
			$fail( __( 'Invalid purchase code.' ) );
		} else {
			$purchaseCode = getEnvatoPurchase( $value, '7ssHZPhSkG9KjoluecIjedwfQxOi9qZc' );

			if ( ! isset( $purchaseCode['buyer'] ) ) {
				$fail( __( 'Invalid purchase code.' ) );
			}
		}
	}
}
