<?php

namespace App\Services;

class Log {

    public static array $actions = [];

    public static function actions(): void {
        self::$actions = [
            '100' => [ 'group' => 'dashboardActivity', 'identifier_type' => 'user_id', 'description' => __( 'Logged in' ) ],
            '101' => [ 'group' => 'dashboardActivity', 'identifier_type' => 'user_id', 'description' => __( 'Entered an incorrect two factor code' ) ],
            '102' => [ 'group' => 'dashboardActivity', 'identifier_type' => 'user_id', 'description' => __( 'Entered an incorrect password' ) ],
            '103' => [ 'group' => 'dashboardActivity', 'identifier_type' => 'user_id', 'description' => __( 'Entered an incorrect email' ) ],
            '104' => [ 'group' => 'dashboardActivity', 'identifier_type' => 'user_id', 'description' => __( 'Bulk deleted activations' ) ],
            '105' => [ 'group' => 'dashboardActivity', 'identifier_type' => 'user_id', 'description' => __( 'Bulk changed activations status' ) ],
            '106' => [ 'group' => 'dashboardActivity', 'identifier_type' => 'user_id', 'description' => __( 'Changed activation status' ) ],
            '107' => [ 'group' => 'dashboardActivity', 'identifier_type' => 'user_id', 'description' => __( 'Bulk deleted API Keys' ) ],
            '108' => [ 'group' => 'dashboardActivity', 'identifier_type' => 'user_id', 'description' => __( 'Updated API Key' ) ],
            '109' => [ 'group' => 'dashboardActivity', 'identifier_type' => 'user_id', 'description' => __( 'Deleted API Key' ) ],
            '110' => [ 'group' => 'dashboardActivity', 'identifier_type' => 'user_id', 'description' => __( 'Created API Key' ) ],
            '111' => [ 'group' => 'dashboardActivity', 'identifier_type' => 'user_id', 'description' => __( 'Bulk changed license key status' ) ],
            '112' => [ 'group' => 'dashboardActivity', 'identifier_type' => 'user_id', 'description' => __( 'Bulk deleted license keys' ) ],
            '113' => [ 'group' => 'dashboardActivity', 'identifier_type' => 'user_id', 'description' => __( 'Updated license key' ) ],
            '114' => [ 'group' => 'dashboardActivity', 'identifier_type' => 'user_id', 'description' => __( 'Created license key' ) ],
            '115' => [ 'group' => 'dashboardActivity', 'identifier_type' => 'user_id', 'description' => __( 'Deleted license key' ) ],
            '116' => [ 'group' => 'dashboardActivity', 'identifier_type' => 'user_id', 'description' => __( 'Created generator' ) ],
            '117' => [ 'group' => 'dashboardActivity', 'identifier_type' => 'user_id', 'description' => __( 'Updated generator' ) ],
            '118' => [ 'group' => 'dashboardActivity', 'identifier_type' => 'user_id', 'description' => __( 'Deleted generator' ) ],
            '119' => [ 'group' => 'dashboardActivity', 'identifier_type' => 'user_id', 'description' => __( 'Generated license keys' ) ],
            '120' => [ 'group' => 'dashboardActivity', 'identifier_type' => 'user_id', 'description' => __( 'Created product' ) ],
            '121' => [ 'group' => 'dashboardActivity', 'identifier_type' => 'user_id', 'description' => __( 'Updated product' ) ],
            '122' => [ 'group' => 'dashboardActivity', 'identifier_type' => 'user_id', 'description' => __( 'Deleted product' ) ],
            '123' => [ 'group' => 'dashboardActivity', 'identifier_type' => 'user_id', 'description' => __( 'Bulk changed product status' ) ],
            '124' => [ 'group' => 'dashboardActivity', 'identifier_type' => 'user_id', 'description' => __( 'Bulk deleted products' ) ],
            '125' => [ 'group' => 'dashboardActivity', 'identifier_type' => 'user_id', 'description' => __( 'Bulk changed generator status' ) ],
            '126' => [ 'group' => 'dashboardActivity', 'identifier_type' => 'user_id', 'description' => __( 'Bulk deleted generators' ) ],
            '130' => [ 'group' => 'dashboardActivity', 'identifier_type' => 'user_id', 'description' => __( 'Created downloadable' ) ],
            '131' => [ 'group' => 'dashboardActivity', 'identifier_type' => 'user_id', 'description' => __( 'Updated downloadable' ) ],
            '132' => [ 'group' => 'dashboardActivity', 'identifier_type' => 'user_id', 'description' => __( 'Deleted downloadable' ) ],
            '133' => [ 'group' => 'dashboardActivity', 'identifier_type' => 'user_id', 'description' => __( 'Bulk changed downloadable status' ) ],
            '134' => [ 'group' => 'dashboardActivity', 'identifier_type' => 'user_id', 'description' => __( 'Bulk deleted downloadables' ) ],
            '140' => [ 'group' => 'dashboardActivity', 'identifier_type' => 'user_id', 'description' => __( 'Created user' ) ],
            '141' => [ 'group' => 'dashboardActivity', 'identifier_type' => 'user_id', 'description' => __( 'Updated user' ) ],
            '142' => [ 'group' => 'dashboardActivity', 'identifier_type' => 'user_id', 'description' => __( 'Deleted user' ) ],
            '150' => [ 'group' => 'dashboardActivity', 'identifier_type' => 'user_id', 'description' => __( 'Changed UI settings' ) ],
            '151' => [ 'group' => 'dashboardActivity', 'identifier_type' => 'user_id', 'description' => __( 'Changed API settings' ) ],
            '152' => [ 'group' => 'dashboardActivity', 'identifier_type' => 'user_id', 'description' => __( 'Changed Envato settings' ) ],
            '160' => [ 'group' => 'dashboardActivity', 'identifier_type' => 'user_id', 'description' => __( 'Deleted activation' ) ],
            '161' => [ 'group' => 'dashboardActivity', 'identifier_type' => 'user_id', 'description' => __( 'Bulk changed API Key status' ) ],
            '200' => [ 'group' => 'apiCalls', 'identifier_type' => 'api_key', 'description' => __( 'Called API endpoint' ) ],
            '201' => [ 'group' => 'apiCalls', 'identifier_type' => 'api_key', 'description' => __( 'Wrong API Key used' ) ],
            '202' => [ 'group' => 'failedApiCalls', 'identifier_type' => 'api_key', 'description' => __( 'Inactive API key used' ) ],
            '203' => [ 'group' => 'failedApiCalls', 'identifier_type' => 'api_key', 'description' => __( 'Attempted to access endpoint without permission' ) ],
            '204' => [ 'group' => 'failedApiCalls', 'identifier_type' => 'api_key', 'description' => __( 'Request sent from the wrong IP address' ) ],
            '205' => [ 'group' => 'blocklistedApiCalls', 'identifier_type' => 'api_key', 'description' => __( 'Access denied: blocklisted IP address' ) ],
            '206' => [ 'group' => 'blocklistedApiCalls', 'identifier_type' => 'api_key', 'description' => __( 'Access denied: blocklisted identifier' ) ],
            '207' => [ 'group' => 'dashboardActivity', 'identifier_type' => 'user_id', 'description' => __( 'Bulk deleted Logs' ) ],
        ];
    }

    public static function add( $action, $identifier, $ipAddress, $data = '' ): void {
        if ( getOption( 'logging', self::$actions[ $action ]['group'], true ) ) {
            $log                       = new \App\Models\Log();
            $log->action               = $action;
            $log->identifier           = $identifier;
            $log->group                = self::$actions[ $action ]['group'];
            $log->ip_address           = $ipAddress;
            $log->data                 = json_encode( $data );
            $log->internal_description = self::$actions[ $action ]['description'];
            $log->created_at           = now();
            $log->save();
        }
    }
}
