<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void {
        Schema::create( 'products', function ( Blueprint $table ) {
            $table->id();
            $table->string( 'external_reference' )->nullable();
            $table->string( 'source' );
            $table->string( 'name' );
            $table->string( 'post_url' )->default( '' );
            $table->text( 'description' );
            $table->string( 'status' );
            $table->boolean( 'require_non_expired' );
            $table->string( 'algorithm' );
            $table->string( 'passphrase' );
            $table->text( 'private_key' );
            $table->timestamps();
        } );
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void {
        Schema::dropIfExists( 'products' );
    }
};
