<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void {
        Schema::create( 'downloadables', function ( Blueprint $table ) {
            $table->id();
            $table->integer( 'product_id' )->unsigned();
            $table->integer( 'numeric_version' )->unsigned();
            $table->string( 'version' );
            $table->string( 'update_summary' );
            $table->string( 'changelog' );
            $table->boolean( 'published' )->default( false );
            $table->timestamp( 'release_date' );
            $table->timestamp( 'assigned_after' )->nullable();
            $table->timestamp( 'assigned_before' )->nullable();
            $table->timestamp( 'expires_before' )->nullable();
            $table->timestamp( 'accessible_until' )->nullable();
            $table->integer( 'download_counter' )->default( 0 );
            $table->timestamps();
        } );
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void {
        Schema::dropIfExists( 'downloadables' );
    }
};
