<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void {
        Schema::create( 'activations', function ( Blueprint $table ) {
            $table->id();
            $table->integer( 'license_key_id' )->unsigned();
            $table->ipAddress()->nullable();
            $table->string( 'identifier' )->nullable();
            $table->string( 'post_url' )->nullable();
            $table->timestamp( 'activation_date' );
            $table->integer( 'activation_counter' )->unsigned()->default( 0 );
            $table->integer( 'deactivation_counter' )->unsigned()->default( 0 );
            $table->string( 'status' )->default( 'active' );
            $table->timestamps();
        } );
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void {
        Schema::dropIfExists( 'activations' );
    }
};
