<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void {
        Schema::create( 'telemetry', function ( Blueprint $table ) {
            $table->id();
            $table->string( 'user_identifier' )->nullable();
            $table->string( 'license_key' )->nullable();
            $table->string( 'activation_identifier' )->nullable();
            $table->integer( 'product_id' )->nullable();
            $table->string( 'product_version' )->nullable();
            $table->string( 'data_type' );
            $table->string( 'data_group' );
            $table->text( 'data' );
            $table->boolean( 'is_correct_format' );
            $table->boolean( 'license_key_exists' );
            $table->boolean( 'product_exists' );
            $table->boolean( 'product_version_exists' );
            $table->boolean( 'has_red_flags' );

            $table->timestamps();
        } );
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void {
        Schema::dropIfExists( 'telemetry' );
    }
};
