<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void {
        Schema::create( 'api_keys', function ( Blueprint $table ) {
            $table->id();
            $table->string( 'api_key' )->unique();
            $table->string( 'description' )->unique();
            $table->ipAddress();
            $table->boolean( 'is_active' );

            $table->boolean( 'can_verify' )->default( false );
            $table->boolean( 'can_activate' )->default( false );
            $table->boolean( 'can_deactivate' )->default( false );

            $table->boolean( 'can_get_license_key_details' )->default( false );
            $table->boolean( 'can_access_downloadables' )->default( false );
            $table->boolean( 'can_assign_license_key' )->default( false );

            $table->boolean( 'can_create_license_key' )->default( false );
            $table->boolean( 'can_create_product' )->default( false );
            $table->boolean( 'can_create_product_meta' )->default( false );
            $table->boolean( 'can_create_license_key_meta' )->default( false );

            $table->boolean( 'can_update_license_key' )->default( false );
            $table->boolean( 'can_update_product' )->default( false );
            $table->boolean( 'can_update_product_meta' )->default( false );
            $table->boolean( 'can_update_license_key_meta' )->default( false );

            $table->boolean( 'can_delete_license_key' )->default( false );
            $table->boolean( 'can_delete_product' )->default( false );
            $table->boolean( 'can_delete_product_meta' )->default( false );
            $table->boolean( 'can_delete_license_key_meta' )->default( false );

            $table->boolean( 'can_get_all_products' )->default( false );
            $table->boolean( 'can_get_license_keys' )->default( false );

            $table->boolean( 'can_get_all_generators' )->default( false );
            $table->boolean( 'can_generate' )->default( false );

            $table->boolean( 'can_send_telemetry_data' )->default( false );
            $table->boolean( 'can_get_telemetry_data' )->default( false );

            $table->boolean( 'can_assign_and_activate_license_key' )->default( false );

            $table->timestamps();
        } );
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void {
        Schema::dropIfExists( 'api_keys' );
    }
};
