<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void {
        Schema::create( 'logs', function ( Blueprint $table ) {
            $table->id();
            $table->integer( 'action' )->unsigned();
            $table->string( 'group' );
            $table->string( 'identifier' );
            $table->string( 'internal_description' );
            $table->text( 'data' )->nullable();
            $table->ipAddress();
            $table->timestamps();
        } );
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void {
        Schema::dropIfExists( 'logs' );
    }
};
