<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void {
        Schema::create( 'metas', function ( Blueprint $table ) {
            $table->id();
            $table->string( 'type' );
            $table->integer( 'item_id' );
            $table->string( 'key' );
            $table->string( 'value' );
            $table->timestamps();

            $table->unique( [ 'type', 'item_id', 'key' ] );
        } );
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void {
        Schema::dropIfExists( 'metas' );
    }
};
