<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void {
        Schema::create( 'dashboard_widgets', function ( Blueprint $table ) {
            $table->id();
            $table->string( 'name' );
            $table->integer( 'product_id' );
            $table->string( 'data_group' );
            $table->string( 'chart_type' );
            $table->string( 'x_axis' );
            $table->string( 'y_axis' );
            $table->boolean( 'is_correct_format' );
            $table->boolean( 'license_key_exists' );
            $table->boolean( 'product_exists' );
            $table->boolean( 'product_version_exists' );
            $table->string( 'conjunction_type' );
            $table->timestamps();
        } );
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void {
        Schema::dropIfExists( 'dashboard_widgets' );
    }
};
