<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
	/**
	 * Run the migrations.
	 */
	public function up(): void {
		Schema::table( 'api_keys', function ( Blueprint $table ) {
			$table->boolean( 'can_get_available_license_keys_count' )->default( false );
		} );
	}

	/**
	 * Reverse the migrations.
	 */
	public function down(): void {
		Schema::table( 'api_keys', function ( Blueprint $table ) {
			$table->dropColumn('can_get_available_license_keys_count');
		} );
	}
};
