<div class="modal fade" id="confirmBulkActionModal" data-bs-backdrop="static" data-bs-keyboard="false" aria-labelledby="confirmBulkActionModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <form id="confirmBulkActionModalLabel">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">{{ __('Confirm Bulk Action') }}</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    {{ __('This action will affect all the selected items.') }}
                </div>
                <div class="modal-footer" x-data="">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('Cancel') }}</button>
                    <button x-on:click="confirmBulkAction()" type="button" class="btn btn-primary">{{ __('Confirm') }}</button>
                </div>
            </div>
        </form>
    </div>
</div>

@push('scripts')
    <script>
        window.addEventListener('open-confirm-bulk-action', event => {
            $('#confirmBulkActionModal').modal('show');
        });

        window.addEventListener('close-confirm-bulk-action', event => {
            $('#confirmBulkActionModal').modal('hide');
        });

        function confirmBulkAction() {
            Livewire.emit('bulkActionConfirmed');
        }

        function bulkDelete() {
            let items = $(".bulk-action-checkbox:checked").map(function () {
                return $(this).val();
            }).get();

            (@this()).set('bulkAction', 'delete');
            (@this()).set('bulkItems', items);

            Livewire.emit('bulkAction');
        }

        function bulkChangeStatus() {
            let items = $(".bulk-action-checkbox:checked").map(function () {
                return $(this).val();
            }).get();

            (@this()).set('bulkAction', 'change-status');
            (@this()).set('bulkActionStatus', $("#bulk-change-status").val());
            (@this()).set('bulkItems', items);

            Livewire.emit('bulkAction');
        }

        window.addEventListener('reset-bulk-input', function (e) {
            $('#bulk-change-status').val('');
            $(".bulk-action-checkbox:checked").prop('checked', false);
            $("#bulk-action-checkbox:checked").prop('checked', false);
        });
    </script>
@endpush
