@extends('vendor.installer.layouts.master')

@section('title', __('Purchase Code Verification'))
@section('style')
    <link href="{{ asset('installer/froiden-helper/helper.css') }}" rel="stylesheet"/>
    <style>
        .form-control {
            height: 14px;
            width: 100%;
        }

        .has-error {
            color: red;
        }

        .has-error input {
            color: black;
            border: 1px solid red;
        }
    </style>
@endsection
@section('container')
    <form method="post" action="{{ route('LaravelInstaller::purchaseCodeSave') }}" id="env-form">
        <div class="form-group">
            <label class="col-sm-2 control-label">{{ __('Purchase Code') }}</label>

            <div class="col-sm-10">
                <input type="text" name="purchaseCode" class="form-control">
            </div>
        </div>

        <div class="modal-footer">
            <div class="buttons">
                <button class="button" onclick="checkEnv(); return false">
                    {{ __('Next Step') }}
                </button>
            </div>
        </div>
    </form>
    <script>
        function checkEnv() {
            $.easyAjax({
                url: "{!! route('LaravelInstaller::purchaseCodeSave') !!}",
                type: "GET",
                data: $("#env-form").serialize(),
                container: "#env-form",
                messagePosition: "inline"
            });
        }
    </script>
@stop
@section('scripts')
    <script src="{{ asset('installer/js/jQuery-2.2.0.min.js') }}"></script>
    <script src="{{ asset('installer/froiden-helper/helper.js')}}"></script>
    <script>
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
    </script>
@endsection
