<div wire:ignore.self class="modal fade" id="toggleActivationModal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="toggleActivationModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <form wire:submit.prevent="toggleActivation" id="toggleActivationForm">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title text-capitalize" id="staticBackdropLabel">{{ $toggleActivationAction == 'active' ? __('Deactivate') : __('Activate') }}</h5>
                </div>
                <div class="modal-body">
                    {{ __('Set') }} #<span wire:ignore id="toggle-activation-item-id"></span> {{ sprintf(__('as %s'), $toggleActivationAction == 'active' ? __('inactive') : __('active') ) }}.
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('Close') }}</button>
                    <button x-on:click="showSpinner()" id="deactivate-item-btn" type="submit" class="btn btn-primary">
                        <span id="deactivate-btn-text">{{ $toggleActivationAction == 'active' ? __('Deactivate') : __('Activate') }}</span>
                        <i id="deactivate-btn-spinner" class="cursor-pointer fas fa-sync fa-spin" style="display: none"></i>
                    </button>
                </div>
            </div>
        </form>
    </div>
</div>

@push('scripts')
    <script>
        function showSpinner() {
            $('#deactivate-btn-text').hide();
            $('#deactivate-btn-spinner').show();
        }

        function openDeactivateModal(id, status) {
            $('#toggleActivationModal').modal('show');
            document.getElementById('toggle-activation-item-id').innerText = id;

            (@this()).set('itemId', id);
            (@this()).set('toggleActivationAction', status);
        }

        window.addEventListener('close-deactivate-modal', event => {
            $('#toggleActivationModal').modal('hide');
        });
    </script>
@endpush
