<div wire:ignore.self class="modal fade" id="addItemModal" data-bs-backdrop="static" data-bs-keyboard="false" aria-hidden="true">
    <div class="modal-dialog">
        <form wire:submit.prevent="createItem" id="createItemForm">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">{{ __('Create API Key') }}</h5>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="product-apiKey">{{ __('API Key') }}</label>
                        <div class="@error('apiKey') border border-danger rounded-3 @enderror">
                            <input id="product-apiKey" wire:model="apiKey" wire:change="createItemUpdated('apiKey')" type="text" class="form-control no-padding">
                        </div>
                        @error('apiKey')
                        <div class="text-danger">{{ $message }}</div> @enderror
                    </div>

                    <div class="mb-3">
                        <label for="api-key-description">{{ __('Description') }}</label>
                        <div class="@error('description') border border-danger rounded-3 @enderror">
                            <textarea id="api-key-description" wire:model="description" wire:change="createItemUpdated('description')" class="form-control no-padding"></textarea>
                        </div>
                        @error('description')
                        <div class="text-danger">{{ $message }}</div> @enderror
                    </div>

                    <div class="mb-3">
                        <label for="product-ipAddress">{{ __('Bind To IP Address') }}</label>
                        <div class="@error('ipAddress') border border-danger rounded-3 @enderror">
                            <input id="product-ipAddress" wire:model="ipAddress" wire:change="createItemUpdated('ipAddress')" type="text" class="form-control no-padding">
                        </div>
                        @error('ipAddress')
                        <div class="text-danger">{{ $message }}</div> @enderror
                    </div>

                    <div class="mb-3">
                        <label for="item-status">{{ __('Status') }}</label>
                        <div id="item-status" class="form-check form-switch ps-0">
                            <input wire:model="status" wire:change="createItemUpdated('status')" class="form-check-input ms-auto" type="checkbox" id="published" checked="">
                            <label class="form-check-label text-body ms-3 text-truncate w-80 mb-0" for="published">
                                {{ __('Active') }}
                            </label>
                        </div>
                    </div>

                    <div class="table-responsive">
                        <table class="table mb-0">
                            <tbody>
                            <tr>
                                <td class="ps-1">
                                    <div class="my-auto">
                                        <span class="text-dark d-block text-sm">{{ __('Verify') }}</span>
                                        <span class="text-xs font-weight-normal">{{ __('Verify license key validity') }}</span>
                                    </div>
                                </td>
                                <td class="align-middle">
                                    <div class="form-check form-switch mb-0 d-flex justify-content-end">
                                        <input class="form-check-input" type="checkbox" wire:model="canVerify">
                                    </div>
                                </td>
                            </tr>

                            <tr>
                                <td class="ps-1">
                                    <div class="my-auto">
                                        <span class="text-dark d-block text-sm">{{ __('Activate') }}</span>
                                        <span class="text-xs font-weight-normal">{{ __('Activate license key') }}</span>
                                    </div>
                                </td>
                                <td class="align-middle">
                                    <div class="form-check form-switch mb-0 d-flex justify-content-end">
                                        <input class="form-check-input" type="checkbox" wire:model="canActivate">
                                    </div>
                                </td>
                            </tr>

                            <tr>
                                <td class="ps-1">
                                    <div class="my-auto">
                                        <span class="text-dark d-block text-sm">{{ __('Deactivate') }}</span>
                                        <span class="text-xs font-weight-normal">{{ __('Deactivate license key') }}</span>
                                    </div>
                                </td>
                                <td class="align-middle">
                                    <div class="form-check form-switch mb-0 d-flex justify-content-end">
                                        <input class="form-check-input" type="checkbox" wire:model="canDeactivate">
                                    </div>
                                </td>
                            </tr>

                            <tr>
                                <td class="ps-1">
                                    <div class="my-auto">
                                        <span class="text-dark d-block text-sm">{{ __('Get License Key Details') }}</span>
                                        <span class="text-xs font-weight-normal">{{ __('License key details') }}</span>
                                    </div>
                                </td>
                                <td class="align-middle">
                                    <div class="form-check form-switch mb-0 d-flex justify-content-end">
                                        <input class="form-check-input" type="checkbox" wire:model="canGetLicenseKeyDetails">
                                    </div>
                                </td>
                            </tr>

                            <tr>
                                <td class="ps-1">
                                    <div class="my-auto">
                                        <span class="text-dark d-block text-sm">{{ __('Access Downloadables') }}</span>
                                        <span class="text-xs font-weight-normal">{{ __('Access product downloadables') }}</span>
                                    </div>
                                </td>
                                <td class="align-middle">
                                    <div class="form-check form-switch mb-0 d-flex justify-content-end">
                                        <input class="form-check-input" type="checkbox" wire:model="canAccessDownloadables">
                                    </div>
                                </td>
                            </tr>

                            <tr>
                                <td class="ps-1">
                                    <div class="my-auto">
                                        <span class="text-dark d-block text-sm">{{ __('Assign License Key') }}</span>
                                        <span class="text-xs font-weight-normal">{{ __('Assign a license key') }}</span>
                                    </div>
                                </td>
                                <td class="align-middle">
                                    <div class="form-check form-switch mb-0 d-flex justify-content-end">
                                        <input class="form-check-input" type="checkbox" wire:model="canAssignLicenseKey">
                                    </div>
                                </td>
                            </tr>

                            <tr>
                                <td class="ps-1">
                                    <div class="my-auto">
                                        <span class="text-dark d-block text-sm">{{ __('Assign And Activate License Key') }}</span>
                                        <span class="text-xs font-weight-normal">{{ __('Assign and activate a license key in one request') }}</span>
                                    </div>
                                </td>
                                <td class="align-middle">
                                    <div class="form-check form-switch mb-0 d-flex justify-content-end">
                                        <input class="form-check-input" type="checkbox" wire:model="canAssignAndActivateLicenseKey">
                                    </div>
                                </td>
                            </tr>

                            <tr>
                                <td class="ps-1">
                                    <div class="my-auto">
                                        <span class="text-dark d-block text-sm">{{ __('Send Telemetry Data') }}</span>
                                        <span class="text-xs font-weight-normal">{{ __('Send product telemetry data') }}</span>
                                    </div>
                                </td>
                                <td class="align-middle">
                                    <div class="form-check form-switch mb-0 d-flex justify-content-end">
                                        <input class="form-check-input" type="checkbox" wire:model="canSendTelemetryData">
                                    </div>
                                </td>
                            </tr>

                            <tr>
                                <td class="ps-1">
                                    <div class="my-auto">
                                        <span class="text-dark d-block text-sm">{{ __('Get Telemetry Data') }}</span>
                                        <span class="text-xs font-weight-normal">{{ __('Get product telemetry data') }}</span>
                                    </div>
                                </td>
                                <td class="align-middle">
                                    <div class="form-check form-switch mb-0 d-flex justify-content-end">
                                        <input class="form-check-input" type="checkbox" wire:model="canGetTelemetryData">
                                    </div>
                                </td>
                            </tr>

                            <tr>
                                <td class="ps-1">
                                    <div class="my-auto">
                                        <span class="text-dark d-block text-sm">{{ __('Create License Keys') }}</span>
                                        <span class="text-xs font-weight-normal">{{ __('Create license keys') }}</span>
                                    </div>
                                </td>
                                <td class="align-middle">
                                    <div class="form-check form-switch mb-0 d-flex justify-content-end">
                                        <input class="form-check-input" type="checkbox" wire:model="canCreateLicenseKeys">
                                    </div>
                                </td>
                            </tr>

                            <tr>
                                <td class="ps-1">
                                    <div class="my-auto">
                                        <span class="text-dark d-block text-sm">{{ __('Create License Key Meta') }}</span>
                                        <span class="text-xs font-weight-normal">{{ __('Create license key meta date') }}</span>
                                    </div>
                                </td>
                                <td class="align-middle">
                                    <div class="form-check form-switch mb-0 d-flex justify-content-end">
                                        <input class="form-check-input" type="checkbox" wire:model="canCreateLicenseKeyMeta">
                                    </div>
                                </td>
                            </tr>

                            <tr>
                                <td class="ps-1">
                                    <div class="my-auto">
                                        <span class="text-dark d-block text-sm">{{ __('Create Products') }}</span>
                                        <span class="text-xs font-weight-normal">{{ __('Create products') }}</span>
                                    </div>
                                </td>
                                <td class="align-middle">
                                    <div class="form-check form-switch mb-0 d-flex justify-content-end">
                                        <input class="form-check-input" type="checkbox" wire:model="canCreateProducts">
                                    </div>
                                </td>
                            </tr>

                            <tr>
                                <td class="ps-1">
                                    <div class="my-auto">
                                        <span class="text-dark d-block text-sm">{{ __('Create Product Meta') }}</span>
                                        <span class="text-xs font-weight-normal">{{ __('Create products meta date') }}</span>
                                    </div>
                                </td>
                                <td class="align-middle">
                                    <div class="form-check form-switch mb-0 d-flex justify-content-end">
                                        <input class="form-check-input" type="checkbox" wire:model="canCreateProductMeta">
                                    </div>
                                </td>
                            </tr>

                            <tr>
                                <td class="ps-1">
                                    <div class="my-auto">
                                        <span class="text-dark d-block text-sm">{{ __('Update License Keys') }}</span>
                                        <span class="text-xs font-weight-normal">{{ __('Update license keys') }}</span>
                                    </div>
                                </td>
                                <td class="align-middle">
                                    <div class="form-check form-switch mb-0 d-flex justify-content-end">
                                        <input class="form-check-input" type="checkbox" wire:model="canUpdateLicenseKeys">
                                    </div>
                                </td>
                            </tr>

                            <tr>
                                <td class="ps-1">
                                    <div class="my-auto">
                                        <span class="text-dark d-block text-sm">{{ __('Update License Key Meta') }}</span>
                                        <span class="text-xs font-weight-normal">{{ __('Update license key meta date') }}</span>
                                    </div>
                                </td>
                                <td class="align-middle">
                                    <div class="form-check form-switch mb-0 d-flex justify-content-end">
                                        <input class="form-check-input" type="checkbox" wire:model="canUpdateLicenseKeyMeta">
                                    </div>
                                </td>
                            </tr>

                            <tr>
                                <td class="ps-1">
                                    <div class="my-auto">
                                        <span class="text-dark d-block text-sm">{{ __('Update Products') }}</span>
                                        <span class="text-xs font-weight-normal">{{ __('Update products') }}</span>
                                    </div>
                                </td>
                                <td class="align-middle">
                                    <div class="form-check form-switch mb-0 d-flex justify-content-end">
                                        <input class="form-check-input" type="checkbox" wire:model="canUpdateProducts">
                                    </div>
                                </td>
                            </tr>

                            <tr>
                                <td class="ps-1">
                                    <div class="my-auto">
                                        <span class="text-dark d-block text-sm">{{ __('Update Product Meta') }}</span>
                                        <span class="text-xs font-weight-normal">{{ __('Update products meta date') }}</span>
                                    </div>
                                </td>
                                <td class="align-middle">
                                    <div class="form-check form-switch mb-0 d-flex justify-content-end">
                                        <input class="form-check-input" type="checkbox" wire:model="canUpdateProductMeta">
                                    </div>
                                </td>
                            </tr>

                            <tr>
                                <td class="ps-1">
                                    <div class="my-auto">
                                        <span class="text-dark d-block text-sm">{{ __('Delete License Keys') }}</span>
                                        <span class="text-xs font-weight-normal">{{ __('Delete license keys') }}</span>
                                    </div>
                                </td>
                                <td class="align-middle">
                                    <div class="form-check form-switch mb-0 d-flex justify-content-end">
                                        <input class="form-check-input" type="checkbox" wire:model="canDeleteLicenseKeys">
                                    </div>
                                </td>
                            </tr>

                            <tr>
                                <td class="ps-1">
                                    <div class="my-auto">
                                        <span class="text-dark d-block text-sm">{{ __('Delete License Key Meta') }}</span>
                                        <span class="text-xs font-weight-normal">{{ __('Delete license key meta date') }}</span>
                                    </div>
                                </td>
                                <td class="align-middle">
                                    <div class="form-check form-switch mb-0 d-flex justify-content-end">
                                        <input class="form-check-input" type="checkbox" wire:model="canDeleteLicenseKeyMeta">
                                    </div>
                                </td>
                            </tr>

                            <tr>
                                <td class="ps-1">
                                    <div class="my-auto">
                                        <span class="text-dark d-block text-sm">{{ __('Delete Products') }}</span>
                                        <span class="text-xs font-weight-normal">{{ __('Delete products') }}</span>
                                    </div>
                                </td>
                                <td class="align-middle">
                                    <div class="form-check form-switch mb-0 d-flex justify-content-end">
                                        <input class="form-check-input" type="checkbox" wire:model="canDeleteProducts">
                                    </div>
                                </td>
                            </tr>

                            <tr>
                                <td class="ps-1">
                                    <div class="my-auto">
                                        <span class="text-dark d-block text-sm">{{ __('Delete Product Meta') }}</span>
                                        <span class="text-xs font-weight-normal">{{ __('Delete products meta date') }}</span>
                                    </div>
                                </td>
                                <td class="align-middle">
                                    <div class="form-check form-switch mb-0 d-flex justify-content-end">
                                        <input class="form-check-input" type="checkbox" wire:model="canDeleteProductMeta">
                                    </div>
                                </td>
                            </tr>


                            <tr>
                                <td class="ps-1">
                                    <div class="my-auto">
                                        <span class="text-dark d-block text-sm">{{ __('Get All Products') }}</span>
                                        <span class="text-xs font-weight-normal">{{ __('Get all products') }}</span>
                                    </div>
                                </td>
                                <td class="align-middle">
                                    <div class="form-check form-switch mb-0 d-flex justify-content-end">
                                        <input class="form-check-input" type="checkbox" wire:model="canGetAllProducts">
                                    </div>
                                </td>
                            </tr>

                            <tr>
                                <td class="ps-1">
                                    <div class="my-auto">
                                        <span class="text-dark d-block text-sm">{{ __('Get All License Keys') }}</span>
                                        <span class="text-xs font-weight-normal">{{ __('Get license keys') }}</span>
                                    </div>
                                </td>
                                <td class="align-middle">
                                    <div class="form-check form-switch mb-0 d-flex justify-content-end">
                                        <input class="form-check-input" type="checkbox" wire:model="canGetLicenseKeys">
                                    </div>
                                </td>
                            </tr>

                            <tr>
                                <td class="ps-1">
                                    <div class="my-auto">
                                        <span class="text-dark d-block text-sm">{{ __('Get All Generators') }}</span>
                                        <span class="text-xs font-weight-normal">{{ __('Get all generators') }}</span>
                                    </div>
                                </td>
                                <td class="align-middle">
                                    <div class="form-check form-switch mb-0 d-flex justify-content-end">
                                        <input class="form-check-input" type="checkbox" wire:model="canGetAllGenerators">
                                    </div>
                                </td>
                            </tr>

                            <tr>
                                <td class="ps-1">
                                    <div class="my-auto">
                                        <span class="text-dark d-block text-sm">{{ __('Generate') }}</span>
                                        <span class="text-xs font-weight-normal">{{ __('Generate') }}</span>
                                    </div>
                                </td>
                                <td class="align-middle">
                                    <div class="form-check form-switch mb-0 d-flex justify-content-end">
                                        <input class="form-check-input" type="checkbox" wire:model="canGenerate">
                                    </div>
                                </td>
                            </tr>

                            <tr>
                                <td class="ps-1">
                                    <div class="my-auto">
                                        <span class="text-dark d-block text-sm">{{ __('Get Available License Keys Count') }}</span>
                                        <span class="text-xs font-weight-normal">{{ __('Get available license keys count by product Id') }}</span>
                                    </div>
                                </td>
                                <td class="align-middle">
                                    <div class="form-check form-switch mb-0 d-flex justify-content-end">
                                        <input class="form-check-input" type="checkbox" wire:model="canGetAvailableLicenseKeysCount">
                                    </div>
                                </td>
                            </tr>

                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="modal-footer">
                    <button wire:click="resetInputs" type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('Close') }}</button>
                    <button id="create-product-btn" type="submit" class="btn btn-primary">{{ __('Create') }}</button>
                </div>
            </div>
        </form>
    </div>
</div>

@push('scripts')
    <script>
        window.addEventListener('open-create-modal', function (e) {
            $('#addItemModal').modal('show');
        });

        window.addEventListener('close-create-modal', function (e) {
            $('#addItemModal').modal('hide');
        });

        $('#create-item-btn').on('click', function (e) {
            e.preventDefault();

            Livewire.emit('createItem');
        });
    </script>
@endpush
