<div wire:ignore.self class="modal fade" id="addWidgetModal" data-bs-backdrop="static" data-bs-keyboard="false" aria-labelledby="addWidgetModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <form id="addWidgetModalLabel">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">{{ __('Add Widget') }}</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="two-factor-code">{{ __('Widget Name') }}</label>
                        <div class="@error('widgetName') border border-danger rounded-3 @enderror">
                            <input id="telemetry-group-input" wire:model="widgetName" wire:change="addWidgetItemUpdated('widgetName')" type="text" class="form-control no-padding">
                        </div>
                        @error('widgetName')
                        <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="mb-3">
                        <label for="products-select" class="form-label">{{ __('Product') }}</label>
                        <div wire:ignore id="products-select-container">
                            <select id="products-select" class="form-select products-select"></select>
                        </div>
                        @error('productId')
                        <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="two-factor-code">{{ __('Chart Type') }}</label>
                        <select wire:model="chartType" wire:change="addWidgetItemUpdated('chartType')" class="form-select form-select-sm m-0">
                            <option value="line">{{ __('Line Chart') }}</option>
                            <option value="bar">{{ __('Bar Chart') }}</option>
                            <option value="pie">{{ __('Pie Chart') }}</option>
                        </select>
                    </div>

                    <div class="mb-3">
                        <label for="two-factor-code">{{ __('Telemetry Group Name') }}</label>
                        <div class="@error('telemetryGroupName') border border-danger rounded-3 @enderror">
                            <input id="telemetry-group-input" wire:model="telemetryGroupName" wire:change="addWidgetItemUpdated('telemetryGroupName')" type="text" class="form-control no-padding">
                        </div>
                        @error('telemetryGroupName')
                        <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="two-factor-code">{{ __('X Axis') }}</label>
                        <select wire:model="xAxis" wire:change="addWidgetItemUpdated('xAxis')" class="form-select form-select-sm m-0">
                            <option value="days">{{ __('Days') }}</option>
                            <option value="records-count">{{ __('Records Count') }}</option>
                            <option value="numeric-data-sum">{{ __('Numeric Data Sum') }}</option>
                        </select>
                    </div>

                    <div class="mb-3">
                        <label for="two-factor-code">{{ __('Y Axis') }}</label>
                        <select wire:model="yAxis" wire:change="addWidgetItemUpdated('yAxis')" class="form-select form-select-sm m-0">
                            <option value="records-count">{{ __('Records Count') }}</option>
                            <option value="numeric-data-sum">{{ __('Numeric Data Sum') }}</option>
                        </select>
                    </div>

                    <div class="mb-3">
                        <label for="two-factor-code">{{ __('Width') }}</label>
                        <div class="@error('widgetWidth') border border-danger rounded-3 @enderror">
                            <input id="widgetWidth" wire:model="widgetWidth" wire:change="addWidgetItemUpdated('widgetWidth')" type="number" class="form-control no-padding">
                        </div>
                        @error('widgetWidth')
                        <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="two-factor-code">{{ __('Telemetry Flags') }}</label>
                        <div class="form-check form-switch ps-0">
                            <input wire:model="isCorrectFormat" class="form-check-input ms-auto" type="checkbox" checked="">
                            <label class="form-check-label text-body ms-3 text-truncate w-80 mb-0" for="requireNonExpired">
                                {{ __('Is Correct Format') }}
                            </label>

                            <input wire:model="licenseKeyExists" class="form-check-input ms-auto" type="checkbox" checked="">
                            <label class="form-check-label text-body ms-3 text-truncate w-80 mb-0" for="requireNonExpired">
                                {{ __('License Key Exists') }}
                            </label>

                            <input wire:model="productExists" class="form-check-input ms-auto" type="checkbox" checked="">
                            <label class="form-check-label text-body ms-3 text-truncate w-80 mb-0" for="requireNonExpired">
                                {{ __('Product Exists') }}
                            </label>

                            <input wire:model="productVersionExists" class="form-check-input ms-auto" type="checkbox" checked="">
                            <label class="form-check-label text-body ms-3 text-truncate w-80 mb-0" for="requireNonExpired">
                                {{ __('Product Version Exists') }}
                            </label>
                        </div>
                    </div>

                    <div class="mb-3">
                        <label>{{ __('Flags Conjunction Type') }}</label>
                        <select wire:model="conjunction" wire:change="addWidgetItemUpdated('conjunction')" class="form-select form-select-sm m-0">
                            <option value="AND">{{ __('AND') }}</option>
                            <option value="OR">{{ __('OR') }}</option>
                        </select>
                    </div>

                </div>
                <div class="modal-footer" x-data="">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('Cancel') }}</button>
                    <button x-on:click="addWidget()" type="button" class="btn btn-primary">{{ __('Confirm') }}</button>
                </div>
            </div>
        </form>
    </div>
</div>

@push('scripts')
    <script>
        document.addEventListener('close-create-modal', function (e) {
            $('#addWidgetModal').modal('hide');
            Livewire.emit('resetInputs');
            location.reload();
        });

        function addWidget() {
            (@this()).set('productId', $('#products-select').select2("val"));
            Livewire.emit('addWidget');
        }

        function openAddWidgetModal() {
            Livewire.emit('resetInputs');

            let modal = $('#addWidgetModal');
            let select = $('#products-select');

            select.html('<option value="0">' + '{{ __('All Products') }}' + '</option>');

            select.select2({
                theme: 'bootstrap-5',
                dropdownParent: $('#products-select-container'),
                ajax: {
                    url: '{{ route('json-products') }}?includeAllOption=1',
                    dataType: 'json',
                },
            });

            $(modal).modal('show');
        }
    </script>
@endpush
