@section('page-title')
    {{ __('Dashboard') }}
@endsection

@section('breadcrumbs')
    <li class="breadcrumb-item text-md">
        <a class="opacity-5 text-dark" href="{{ route('dashboard') }}">
            {{ __('Dashboard') }}
        </a>
    </li>
@endsection

<div>
    <div class="container-fluid py-4">

        <div class="row">
            <div class="col-xl-3 col-sm-6 mb-xl-0 mb-4">
                <div class="card">
                    <div class="card-body p-3">
                        <div class="row">
                            <div class="col-8">
                                <div class="numbers">
                                    <p class="text-sm mb-0 text-capitalize font-weight-bold">{{ __("Total Activations") }}</p>
                                    <h5 class="font-weight-bolder mb-0">
                                        {{ $totalActivations }}
                                        <span class="text-success text-sm font-weight-bolder">{{ $todayActivations }}</span>
                                        <span class="text-success text-sm font-weight-normal">{{ __('today') }}</span>
                                    </h5>
                                </div>
                            </div>
                            <div class="col-4 text-end">
                                <div class="icon icon-shape bg-gradient-primary shadow text-center border-radius-md">
                                    <i class="fas fa-layer-group text-lg opacity-10" aria-hidden="true"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-xl-3 col-sm-6 mb-xl-0 mb-4">
                <div class="card">
                    <div class="card-body p-3">
                        <div class="row">
                            <div class="col-8">
                                <div class="numbers">
                                    <p class="text-sm mb-0 text-capitalize font-weight-bold">{{ __("Total Downloads") }}</p>
                                    <h5 class="font-weight-bolder mb-0">
                                        {{ $totalDownloads }}
                                        <span class="text-success text-sm font-weight-bolder">{{ $todayDownloads }}</span>
                                        <span class="text-success text-sm font-weight-normal">{{ __('today') }}</span>
                                    </h5>
                                </div>
                            </div>
                            <div class="col-4 text-end">
                                <div class="icon icon-shape bg-gradient-primary shadow text-center border-radius-md">
                                    <i class="far fa-arrow-alt-circle-down text-lg opacity-10" aria-hidden="true"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-xl-3 col-sm-6 mb-xl-0 mb-4">
                <div class="card">
                    <div class="card-body p-3">
                        <div class="row">
                            <div class="col-8">
                                <div class="numbers">
                                    <p class="text-sm mb-0 text-capitalize font-weight-bold">{{ __("Telemetry Data Collected") }}</p>
                                    <h5 class="font-weight-bolder mb-0">
                                        {{ $totalTelemetry }}
                                        <span class="text-success text-sm font-weight-bolder">{{ $todayTelemetry }}</span>
                                        <span class="text-success text-sm font-weight-normal">{{ __('today') }}</span>
                                    </h5>
                                </div>
                            </div>
                            <div class="col-4 text-end">
                                <div class="icon icon-shape bg-gradient-primary shadow text-center border-radius-md">
                                    <i class="fas fa-server text-lg opacity-10" aria-hidden="true"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-xl-3 col-sm-6 mb-xl-0">
                <div class="card">
                    <div class="card-body p-3">
                        <div class="row">
                            <div class="col-8">
                                <div class="numbers">
                                    <p class="text-sm mb-0 text-capitalize font-weight-bold">{{ __("Total License Keys") }}</p>
                                    <h5 class="font-weight-bolder mb-0">
                                        {{ $totalLicenseKeys }}
                                        <span class="text-success text-sm font-weight-bolder">{{ $todayLicenseKeys }}</span>
                                        <span class="text-success text-sm font-weight-normal">{{ __('today') }}</span>
                                    </h5>
                                </div>
                            </div>
                            <div class="col-4 text-end">
                                <div class="icon icon-shape bg-gradient-primary shadow text-center border-radius-md">
                                    <i class="fas fa-key text-lg opacity-10" aria-hidden="true"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="row my-4">
            <div class="col-12">
                <div class="card">
                    <ul class="list-group" x-data="{}">
                        <li class="list-group-item">
                            <div class="float-start">
                                <form class="form-inline">
                                    <select wire:model="daysPerGraph" wire:change="daysPerGraphChanged" id="days-per-graph" class="form-select form-select-sm m-0">
                                        <option value="7">{{ __('7 Days') }}</option>
                                        <option value="15">{{ __('15 Days') }}</option>
                                        <option value="30">{{ __('30 Days') }}</option>
                                    </select>
                                </form>
                            </div>

                            <div class="float-end">
                                <button x-on:click="openAddWidgetModal()" type="button" class="btn btn-action-apply btn-action-apply mb-0 me-1">
                                    <span class="btn-inner--text"><i class="fas fa-plus me-2"></i>{{ __('Widget') }}</span>
                                </button>

                                <button x-on:click="openReorderWidgetModal()" type="button" class="btn btn-action-apply btn-action-apply mb-0 me-0">
                                    <i class="fas fa-bars"></i>
                                </button>
                            </div>
                        </li>
                    </ul>
                </div>
            </div>
        </div>

        <div class="row">
            @foreach($positions as $widget => $value)
                @if($widget == 'built-in-telemetry-data' && $visibility['built-in-telemetry-data'])
                    <div class="col-lg-{{ $columns['built-in-telemetry-data'] }} mb-4">
                        <div class="card">
                            <div class="card-body p-3">
                                <div class="bg-gradient-dark border-radius-lg py-3 pe-1 mb-3">
                                    <div class="chart">
                                        <canvas wire:ignore id="chart-bars" class="chart-canvas" height="194px"></canvas>
                                    </div>
                                </div>
                                <h6 class="ms-2 mt-3 mb-0">{{ __('Telemetry Data') }}</h6>
                                <div>
                                    <div class="row ps-3">
                                        <div class="col-3 py-3 pb-0 ps-0">
                                            <div class="d-flex mb-2">
                                                <div class="icon icon-shape icon-xxs shadow border-radius-sm bg-gradient-danger text-center me-2 d-flex align-items-center justify-content-center">
                                                    <i class="fas fa-times mt-2 p-2"></i>
                                                </div>
                                                <p class="text-xs mt-1 mb-0 font-weight-bold telemetry-label">{{ __("Incorrect Format") }}</p>
                                            </div>
                                            <h4 class="font-weight-bolder mb-0">{{ $telemetryDataCount['incorrectFormat'] }}</h4>
                                        </div>
                                        <div class="col-3 py-3 pb-0 ps-0">
                                            <div class="d-flex mb-2">
                                                <div class="icon icon-shape icon-xxs shadow border-radius-sm bg-gradient-primary text-center me-2 d-flex align-items-center justify-content-center">
                                                    <i class="fas fa-lock mt-2 p-2"></i>
                                                </div>
                                                <p class="text-xs mt-1 mb-0 font-weight-bold telemetry-label">{{ __("Invalid License") }}</p>
                                            </div>
                                            <h4 class="font-weight-bolder mb-0">{{ $telemetryDataCount['invalidLicenseKeys'] }}</h4>
                                        </div>
                                        <div class="col-3 py-3 pb-0 ps-0">
                                            <div class="d-flex mb-2">
                                                <div class="icon icon-shape icon-xxs shadow border-radius-sm bg-gradient-info text-center me-2 d-flex align-items-center justify-content-center">
                                                    <i class="fas fa-store-alt-slash mt-2 p-2"></i>
                                                </div>
                                                <p class="text-xs mt-1 mb-0 font-weight-bold telemetry-label">{{ __("Invalid Product") }}</p>
                                            </div>
                                            <h4 class="font-weight-bolder mb-0">{{ $telemetryDataCount['invalidProduct'] }}</h4>
                                        </div>
                                        <div class="col-3 py-3 pb-0 ps-0">
                                            <div class="d-flex mb-2">
                                                <div class="icon icon-shape icon-xxs shadow border-radius-sm bg-gradient-warning text-center me-2 d-flex align-items-center justify-content-center">
                                                    <i class="fas fa-code-branch mt-2 p-2"></i>
                                                </div>
                                                <p class="text-xs mt-1 mb-0 font-weight-bold telemetry-label">{{ __("Invalid Version") }}</p>
                                            </div>
                                            <h4 class="font-weight-bolder mb-0">{{ $telemetryDataCount['invalidVersions'] }}</h4>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                @elseif($widget == 'built-in-activations' && $visibility['built-in-activations'])
                    <div class="col-lg-{{ $columns['built-in-activations'] }} mb-4">
                        <div class="card">
                            <div class="card-header pb-0">
                                <h6>{{ __('Activations') }}</h6>
                            </div>
                            <div class="card-body p-3">
                                <div class="chart">
                                    <canvas wire:ignore id="chart-line" class="chart-canvas" height="300px"></canvas>
                                </div>
                            </div>
                        </div>
                    </div>
                @elseif($widget == 'built-in-downloads' && $visibility['built-in-downloads'])
                    <div class="col-lg-{{ $columns['built-in-downloads'] }} mb-4">
                        <div class="card">
                            <div class="card-header pb-0">
                                <h6>{{ __('Downloads') }}</h6>
                            </div>
                            <div class="card-body p-3">
                                <div class="chart">
                                    <canvas wire:ignore id="downloads-graph" class="chart-canvas" height="300px"></canvas>
                                </div>
                            </div>
                        </div>
                    </div>
                @elseif($widget == 'built-in-license-keys' && $visibility['built-in-license-keys'])
                    <div class="col-lg-{{ $columns['built-in-license-keys'] }} mb-4">
                        <div class="card">
                            <div class="card-header pb-0">
                                <h6>{{ __('License Keys') }}</h6>
                            </div>
                            <div class="card-body p-3">
                                <div class="chart">
                                    <canvas wire:ignore id="license-keys-graph" class="chart-canvas" height="300px"></canvas>
                                </div>
                            </div>
                        </div>
                    </div>
                @elseif(!in_array($widget, ['built-in-license-keys', 'built-in-downloads', 'built-in-activations', 'built-in-telemetry-data']))
                    <div class="col-lg-{{ $columns[$widget] }} mb-4">
                        <div class="card">
                            <div class="card-header pb-0">
                                <h6>{{ $customWidgets[$widget]['name'] }}</h6>
                            </div>
                            <div class="card-body p-3">
                                <div class="chart">
                                    <canvas wire:ignore id="custom-chart{{ $customWidgets[$widget]['id'] }}" class="chart-canvas" height="300px"></canvas>
                                </div>
                            </div>
                        </div>
                    </div>
                @endif
            @endforeach
        </div>
    </div>

    @include('livewire.dashboard.add-widget-modal')
    @include('livewire.dashboard.reorder-widgets')
</div>

@push('scripts')
    <script src="{{ asset('assets/js/plugins/chartjs.min.js') }}"></script>
    <script src="{{ asset('assets/js/plugins/Chart.extension.js') }}"></script>

    @foreach($positions as $widget => $value)
        @if(!in_array($widget, ['built-in-telemetry-data', 'built-in-license-keys', 'built-in-downloads', 'built-in-activations']))
            <script>
                let customGraphData{{ $customWidgets[$widget]['id'] }} = {
                    type: "{{ $customWidgets[$widget]['chart_type'] }}",
                    data: {
                        labels: @json($customWidgetData[ 'customWidget' . $customWidgets[$widget]['id'] ]['x']),
                        datasets: [
                            {
                                label: "{{ $customWidgets[$widget]['name'] }}",
                                tension: 0.4,
                                pointRadius: 0,
                                borderColor: "{{ strToColor($customWidgets[$widget]['name']) }}",
                                borderWidth: 3,
                                data: @json($customWidgetData[ 'customWidget' . $customWidgets[$widget]['id'] ]['y']),
                                maxBarThickness: 6
                            }
                        ],
                    },
                    options: {
                        responsive: true,
                        maintainAspectRatio: false,
                        legend: {
                            display: false,
                        },
                        tooltips: {
                            enabled: true,
                            mode: "index",
                            intersect: false,
                        },
                        scales: {
                            yAxes: [{
                                gridLines: {
                                    borderDash: [2],
                                    borderDashOffset: [2],
                                    color: '#dee2e6',
                                    zeroLineColor: '#dee2e6',
                                    zeroLineWidth: 1,
                                    zeroLineBorderDash: [2],
                                    drawBorder: false,
                                },
                                ticks: {
                                    suggestedMin: 0,
                                    suggestedMax: {{ max($customWidgetData[ 'customWidget' . $customWidgets[$widget]['id'] ]['y']) }},
                                    beginAtZero: true,
                                    padding: 10,
                                    fontSize: 11,
                                    fontColor: '#adb5bd',
                                    lineHeight: 3,
                                    fontStyle: 'normal',
                                    fontFamily: "Open Sans",
                                    callback: function (value, index, values) {
                                        if (Math.floor(value) === value) {
                                            return value;
                                        }
                                    }
                                },
                            },],
                            xAxes: [{
                                gridLines: {
                                    zeroLineColor: 'rgba(0,0,0,0)',
                                    display: false,
                                },
                                ticks: {
                                    padding: 10,
                                    fontSize: 11,
                                    fontColor: '#adb5bd',
                                    lineHeight: 3,
                                    fontStyle: 'normal',
                                    fontFamily: "Open Sans",
                                },
                            },],
                        },
                    },
                };

                let customGraph{{ $customWidgets[$widget]['id'] }} = document.getElementById("custom-chart{{ $customWidgets[$widget]['id'] }}").getContext("2d");
                let gradientStrokeCustom{{ $customWidgets[$widget]['id'] }} = customGraph{{ $customWidgets[$widget]['id'] }}.createLinearGradient(0, 230, 0, 50);
                gradientStrokeCustom{{ $customWidgets[$widget]['id'] }}.addColorStop(1, '{{ strToColor($customWidgets[$widget]['name']) }}66');
                gradientStrokeCustom{{ $customWidgets[$widget]['id'] }}.addColorStop(0.2, '{{ strToColor($customWidgets[$widget]['name']) }}33');
                gradientStrokeCustom{{ $customWidgets[$widget]['id'] }}.addColorStop(0, '{{ strToColor($customWidgets[$widget]['name']) }}00');
                customGraphData{{ $customWidgets[$widget]['id'] }}.data.datasets[0].backgroundColor = gradientStrokeCustom{{ $customWidgets[$widget]['id'] }};

                customGraph{{ $customWidgets[$widget]['id'] }} = new Chart(customGraph{{ $customWidgets[$widget]['id'] }}, customGraphData{{ $customWidgets[$widget]['id'] }});

                document.addEventListener('redrawGraph', event => {
                    customGraphData{{ $customWidgets[$widget]['id'] }}.data.labels = event.detail.customWidget{{ $customWidgets[$widget]['id'] }}.x;
                    customGraphData{{ $customWidgets[$widget]['id'] }}.data.datasets[0].data = event.detail.customWidget{{ $customWidgets[$widget]['id'] }}.y;
                    customGraph{{ $customWidgets[$widget]['id'] }}.update();
                })

            </script>
        @endif
    @endforeach


    @if($visibility['built-in-telemetry-data'])
        <script>
            let telemetryGraphData = {
                type: "bar",
                data: {
                    labels: @json($telemetryGraphData['days']),
                    datasets: [
                        {
                            label: "{{ __('No red flags') }}",
                            tension: 0.4,
                            borderWidth: 0,
                            pointRadius: 0,
                            backgroundColor: "#27ae60",
                            data: @json($telemetryGraphData['correct']),
                            maxBarThickness: 6
                        },
                        {
                            label: "{{ __('Has red flags') }}",
                            tension: 0.4,
                            borderWidth: 0,
                            pointRadius: 0,
                            backgroundColor: "#e74c3c",
                            data: @json($telemetryGraphData['incorrect']),
                            maxBarThickness: 6
                        }
                    ],
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    legend: {
                        display: false,
                    },
                    tooltips: {
                        enabled: true,
                        mode: "index",
                        intersect: false,
                    },
                    scales: {
                        yAxes: [{
                            gridLines: {
                                display: false,
                            },
                            ticks: {
                                suggestedMin: 0,
                                suggestedMax: {{ max( array_merge( $telemetryGraphData['correct'], $telemetryGraphData['incorrect'] ) ) }},
                                beginAtZero: true,
                                padding: 0,
                                fontSize: 14,
                                lineHeight: 3,
                                fontColor: "#fff",
                                fontStyle: 'normal',
                                fontFamily: "Open Sans",
                                callback: function (value, index, values) {
                                    if (Math.floor(value) === value) {
                                        return value;
                                    }
                                }
                            },
                        },],
                        xAxes: [{
                            gridLines: {
                                display: false,
                            },
                            ticks: {
                                display: true,
                                fontColor: '#adb5bd',
                            },
                        },],
                    },
                },
            };

            let telemetryGraph = document.getElementById("chart-bars").getContext("2d");
            telemetryGraph = new Chart(telemetryGraph, telemetryGraphData);

            document.addEventListener('redrawGraph', event => {
                telemetryGraphData.data.labels = event.detail.telemetryGraphData.days;
                telemetryGraphData.data.datasets[0].data = event.detail.telemetryGraphData.correct;
                telemetryGraphData.data.datasets[1].data = event.detail.telemetryGraphData.incorrect;
                telemetryGraph.update();
            })
        </script>
    @endif

    @if($visibility['built-in-activations'])
        <script>
            let activationsGraphData = {
                type: "line",
                data: {
                    labels: @json($activationsGraphData['days']),
                    datasets: [
                        {
                            label: "{{ __('Activations') }}",
                            tension: 0.4,
                            pointRadius: 0,
                            borderColor: "#fbcf33",
                            borderWidth: 3,
                            data: @json($activationsGraphData['activations']),
                            maxBarThickness: 6
                        }
                    ],
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    legend: {
                        display: false,
                    },
                    tooltips: {
                        enabled: true,
                        mode: "index",
                        intersect: false,
                    },
                    scales: {
                        yAxes: [{
                            gridLines: {
                                borderDash: [2],
                                borderDashOffset: [2],
                                color: '#dee2e6',
                                zeroLineColor: '#dee2e6',
                                zeroLineWidth: 1,
                                zeroLineBorderDash: [2],
                                drawBorder: false,
                            },
                            ticks: {
                                suggestedMin: 0,
                                suggestedMax: {{ max($activationsGraphData['activations']) }},
                                beginAtZero: true,
                                padding: 10,
                                fontSize: 11,
                                fontColor: '#adb5bd',
                                lineHeight: 3,
                                fontStyle: 'normal',
                                fontFamily: "Open Sans",
                                callback: function (value, index, values) {
                                    if (Math.floor(value) === value) {
                                        return value;
                                    }
                                }
                            },
                        },],
                        xAxes: [{
                            gridLines: {
                                zeroLineColor: 'rgba(0,0,0,0)',
                                display: false,
                            },
                            ticks: {
                                padding: 10,
                                fontSize: 11,
                                fontColor: '#adb5bd',
                                lineHeight: 3,
                                fontStyle: 'normal',
                                fontFamily: "Open Sans",
                            },
                        },],
                    },
                },
            };

            let activationsGraph = document.getElementById("chart-line").getContext("2d");
            let gradientStroke1 = activationsGraph.createLinearGradient(0, 230, 0, 50);
            gradientStroke1.addColorStop(1, 'rgba(253,235,173,0.4)');
            gradientStroke1.addColorStop(0.2, 'rgba(253,235,173,0.2)');
            gradientStroke1.addColorStop(0, 'rgba(253,235,173,0)');
            activationsGraphData.data.datasets[0].backgroundColor = gradientStroke1;

            activationsGraph = new Chart(activationsGraph, activationsGraphData);

            document.addEventListener('redrawGraph', event => {
                activationsGraphData.data.labels = event.detail.activationsGraphData.days;
                activationsGraphData.data.datasets[0].data = event.detail.activationsGraphData.activations;
                activationsGraph.update();
            })

        </script>
    @endif

    @if($visibility['built-in-downloads'])
        <script>
            let downloadsGraphData = {
                type: "line",
                data: {
                    labels: @json($downloadsGraphData['days']),
                    datasets: [
                        {
                            label: "{{ __('Downloads') }}",
                            tension: 0.4,
                            pointRadius: 0,
                            borderColor: "#8e44ad",
                            borderWidth: 3,
                            data: @json($downloadsGraphData['downloads']),
                            maxBarThickness: 6
                        }
                    ],
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    legend: {
                        display: false,
                    },
                    tooltips: {
                        enabled: true,
                        mode: "index",
                        intersect: false,
                    },
                    scales: {
                        yAxes: [{
                            gridLines: {
                                borderDash: [2],
                                borderDashOffset: [2],
                                color: '#dee2e6',
                                zeroLineColor: '#dee2e6',
                                zeroLineWidth: 1,
                                zeroLineBorderDash: [2],
                                drawBorder: false,
                            },
                            ticks: {
                                suggestedMin: 0,
                                suggestedMax: {{ max($downloadsGraphData['downloads']) }},
                                beginAtZero: true,
                                padding: 10,
                                fontSize: 11,
                                fontColor: '#adb5bd',
                                lineHeight: 3,
                                fontStyle: 'normal',
                                fontFamily: "Open Sans",
                                callback: function (value, index, values) {
                                    if (Math.floor(value) === value) {
                                        return value;
                                    }
                                }
                            },
                        },],
                        xAxes: [{
                            gridLines: {
                                zeroLineColor: 'rgba(0,0,0,0)',
                                display: false,
                            },
                            ticks: {
                                padding: 10,
                                fontSize: 11,
                                fontColor: '#adb5bd',
                                lineHeight: 3,
                                fontStyle: 'normal',
                                fontFamily: "Open Sans",
                            },
                        },],
                    },
                },
            };

            let downloadsGraph = document.getElementById("downloads-graph").getContext("2d");

            let gradientStroke2 = downloadsGraph.createLinearGradient(0, 230, 0, 50);
            gradientStroke2.addColorStop(1, 'rgba(205,173,253,0.4)');
            gradientStroke2.addColorStop(0.2, 'rgba(205,173,253, 0.2)');
            gradientStroke2.addColorStop(0, 'rgba(205,173,253,0)');
            downloadsGraphData.data.datasets[0].backgroundColor = gradientStroke2;

            downloadsGraph = new Chart(downloadsGraph, downloadsGraphData);

            document.addEventListener('redrawGraph', event => {
                downloadsGraphData.data.labels = event.detail.downloadsGraphData.days;
                downloadsGraphData.data.datasets[0].data = event.detail.downloadsGraphData.downloads;
                downloadsGraph.update();
            })

        </script>
    @endif

    @if($visibility['built-in-license-keys'])
        <script>
            let licenseKeysGraphData = {
                type: "pie",
                data: {
                    labels: @json($licenseKeysGraphData['status']),
                    datasets: [
                        {
                            label: "{{ __('License keys') }}",
                            data: @json($licenseKeysGraphData['count']),
                            backgroundColor: @json($licenseKeysGraphData['color']),
                        }
                    ],
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    legend: {
                        display: true,
                    },
                    tooltips: {
                        enabled: true,
                        mode: "index",
                        intersect: false,
                    },
                },
            };

            let licenseKeysGraph = document.getElementById("license-keys-graph").getContext("2d");
            licenseKeysGraph = new Chart(licenseKeysGraph, licenseKeysGraphData);

            document.addEventListener('redrawGraph', event => {
                licenseKeysGraphData.data.labels = event.detail.licenseKeysGraphData.status;
                licenseKeysGraphData.data.datasets[0].data = event.detail.licenseKeysGraphData.count;
                licenseKeysGraphData.data.datasets[0].backgroundColor = event.detail.licenseKeysGraphData.color;
                licenseKeysGraph.update();
            })
        </script>
    @endif
@endpush
