<div wire:ignore class="modal fade" id="reorderWidgetModal" data-bs-backdrop="static" data-bs-keyboard="false" aria-labelledby="reorderWidgetModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <form id="reorderWidgetModalLabel" wire:submit.prevent="saveWidgetsConfiguration">
            <input type="hidden" id="widgets-items-order" value="">

            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">{{ __('Reorder Widget') }}</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body" x-data="">
                    <ul class="draggable p-0 m-0">
                        @foreach($positions as $widget => $position)
                            @if($widget == 'built-in-telemetry-data')
                                <li data-item="built-in-telemetry-data" class="card border-1 border-radius-none p-2 mb-1 cursor-drag shadow-none inline">
                                    <span>
                                        <i class="fas fa-bars mx-2"></i> {{ __('Telemetry Data') }}
                                        <span class="d-inline-block float-end cursor-pointer widget-action-btn">
                                            <i id="visibility-built-in-telemetry-data-on" x-on:click="setBuiltInWidgetVisibility('built-in-telemetry-data', false)" class="fas fa-eye-slash text-secondary text-end {{ $visibility['built-in-telemetry-data'] ? '' : 'hide' }}"></i>
                                            <i id="visibility-built-in-telemetry-data-off" x-on:click="setBuiltInWidgetVisibility('built-in-telemetry-data', true)" class="fas fa-eye text-secondary text-end {{ $visibility['built-in-telemetry-data'] ? 'hide' : '' }}"></i>
                                        </span>

                                        <label class="mb-0 float-end">{{ __('Columns') }}:
                                            <input class="widgets-columns-input" type="number" wire:model="columns.built-in-telemetry-data" value="{{ $columns['built-in-telemetry-data'] }}" min="4" max="12">
                                            <span class="me-2">/12</span>
                                        </label>
                                    </span>
                                </li>
                            @elseif($widget == 'built-in-activations')
                                <li data-item="built-in-activations" class="card border-1 border-radius-none p-2 mb-1 cursor-drag shadow-none inline">
                                    <span>
                                        <i class="fas fa-bars mx-2"></i> {{ __('Activations') }}
                                        <span class="d-inline-block float-end cursor-pointer widget-action-btn">
                                            <i id="visibility-built-in-activations-on" x-on:click="setBuiltInWidgetVisibility('built-in-activations', false)" class="fas fa-eye-slash text-secondary text-end {{ $visibility['built-in-activations'] ? '' : 'hide' }}"></i>
                                            <i id="visibility-built-in-activations-off" x-on:click="setBuiltInWidgetVisibility('built-in-activations', true)" class="fas fa-eye text-secondary text-end {{ $visibility['built-in-activations'] ? 'hide' : '' }}"></i>
                                        </span>

                                        <label class="mb-0 float-end">{{ __('Columns') }}:
                                            <input class="widgets-columns-input" type="number" wire:model="columns.built-in-activations" value="{{ $columns['built-in-activations'] }}" min="4" max="12">
                                            <span class="me-2">/12</span>
                                        </label>
                                    </span>
                                </li>
                            @elseif($widget == 'built-in-downloads')
                                <li data-item="built-in-downloads" class="card border-1 border-radius-none p-2 mb-1 cursor-drag shadow-none inline">
                                    <span>
                                        <i class="fas fa-bars mx-2"></i> {{ __('Downloads') }}
                                        <span class="d-inline-block float-end cursor-pointer widget-action-btn">
                                            <i id="visibility-built-in-downloads-on" x-on:click="setBuiltInWidgetVisibility('built-in-downloads', false)" class="fas fa-eye-slash text-secondary text-end {{ $visibility['built-in-downloads'] ? '' : 'hide' }}"></i>
                                            <i id="visibility-built-in-downloads-off" x-on:click="setBuiltInWidgetVisibility('built-in-downloads', true)" class="fas fa-eye text-secondary text-end {{ $visibility['built-in-downloads'] ? 'hide' : '' }}"></i>
                                        </span>

                                        <label class="mb-0 float-end">{{ __('Columns') }}:
                                            <input class="widgets-columns-input" type="number" wire:model="columns.built-in-downloads" value="{{ $columns['built-in-downloads'] }}" min="4" max="12">
                                            <span class="me-2">/12</span>
                                        </label>
                                    </span>
                                </li>
                            @elseif($widget == 'built-in-license-keys')
                                <li data-item="built-in-license-keys" class="card border-1 border-radius-none p-2 mb-1 cursor-drag shadow-none inline">
                                    <span>
                                        <i class="fas fa-bars mx-2"></i> {{ __('License Keys') }}
                                        <span class="d-inline-block float-end cursor-pointer widget-action-btn">
                                            <i id="visibility-built-in-license-keys-on" x-on:click="setBuiltInWidgetVisibility('built-in-license-keys', false)" class="fas fa-eye-slash text-secondary text-end {{ $visibility['built-in-license-keys'] ? '' : 'hide' }}"></i>
                                            <i id="visibility-built-in-license-keys-off" x-on:click="setBuiltInWidgetVisibility('built-in-license-keys', true)" class="fas fa-eye text-secondary text-end {{ $visibility['built-in-license-keys'] ? 'hide' : '' }}"></i>
                                        </span>

                                        <label class="mb-0 float-end">{{ __('Columns') }}:
                                            <input class="widgets-columns-input" type="number" wire:model="columns.built-in-license-keys" value="{{ $columns['built-in-license-keys'] }}" min="4" max="12">
                                            <span class="me-2">/12</span>
                                        </label>
                                    </span>
                                </li>
                            @else
                                <li data-item="{{ $widget }}" class="card border-1 border-radius-none p-2 mb-1 cursor-drag shadow-none inline">
                                    <span class="widget-reorder-container">
                                        <i class="fas fa-bars mx-2"></i>
                                        <span class="widget-reorder-name">{{ $customWidgets[$widget]['name'] }}</span>
                                        <span class="d-inline-block float-end cursor-pointer widget-action-btn">
                                            <i id="delete-{{ $widget }}-no" x-on:click="deleteCustomWidget({{ $customWidgets[$widget]['id'] }}, true)" class="fas fa-trash text-secondary text-end"></i>
                                            <i id="delete-{{ $widget }}-yes" x-on:click="deleteCustomWidget({{ $customWidgets[$widget]['id'] }}, false)" class="fas fa-trash text-danger text-end hide"></i>
                                        </span>

                                        <label class="mb-0 float-end">{{ __('Columns') }}:
                                            <input class="widgets-columns-input" type="number" wire:model="columns.{{ $widget }}" value="{{ $columns[$widget] }}" min="4" max="12">
                                            <span class="me-2">/12</span>
                                        </label>
                                    </span>
                                </li>
                            @endif
                        @endforeach
                    </ul>
                </div>
                <div class="modal-footer" x-data="">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('Cancel') }}</button>
                    <button type="submit" class="btn btn-primary">{{ __('Confirm') }}</button>
                </div>
            </div>
        </form>
    </div>
</div>

@push('scripts')
    <script>
        function deleteCustomWidget(widget, status) {
            (@this()).set('deleteTemp.custom-' + widget, status);

            if (status) {
                $('#delete-custom-' + widget + '-no').hide();
                $('#delete-custom-' + widget + '-yes').show();
            } else {
                $('#delete-custom-' + widget + '-no').show();
                $('#delete-custom-' + widget + '-yes').hide();
            }
        }

        function setBuiltInWidgetVisibility(widget, status) {
            (@this()).set('visibilityTemp.' + widget, status);

            if (status) {
                $('#visibility-' + widget + '-on').show();
                $('#visibility-' + widget + '-off').hide();
            } else {
                $('#visibility-' + widget + '-on').hide();
                $('#visibility-' + widget + '-off').show();
            }
        }

        document.addEventListener('close-reorder-modal', function (e) {
            $('#reorderWidgetModal').modal('hide');

            location.reload();
        });

        function openReorderWidgetModal() {
            $(".draggable").sortable({
                items: "li",
                cursor: "pointer",
                axis: "y",
                dropOnEmpty: false,
                start: function (e, ui) {
                    ui.item.addClass("selected");
                },
                stop: function (e, ui) {
                    ui.item.removeClass("selected");
                    let order = "";
                    $(this).find("li").each(function (index) {
                        order = order + "," + $(this).data("item");

                        if (order.charAt(0) === ",") {
                            order = order.substring(1);
                        }

                        $("#widgets-items-order").val(order);
                    });

                    (@this()).set('widgetsItemsOrder', $("#widgets-items-order").val());
                },
            });

            $('#reorderWidgetModal').modal('show');
        }
    </script>
@endpush
