<div wire:ignore.self class="modal fade" id="addItemModal" data-bs-backdrop="static" data-bs-keyboard="false" aria-labelledby="addItemModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl">
        <form wire:submit.prevent="createItem" id="addItemForm">
            <div class="modal-content">
                <div class="modal-body">
                    <div class="row">
                        <div class="col-6">
                            <h5>{{ __('New Downloadable Details') }}</h5>

                            <div id="products-select-container" class="mb-3" wire:ignore>
                                <label for="products-select" class="form-label">{{ __('Product') }}</label>
                                <select id="products-select" class="form-select products-select"></select>
                            </div>

                            <div class="mb-3">
                                <label for="item-version">{{ __('Version') }}</label>
                                <div class="@error('version') border border-danger rounded-3 @enderror">
                                    <input id="item-version" wire:model="version" wire:change="createItemUpdated('version')" type="text" class="form-control no-padding">
                                </div>
                                @error('version')
                                <div class="text-danger">{{ $message }}</div> @enderror
                            </div>

                            <div class="mb-3">
                                <label for="item-numeric-version">{{ __('Numeric Version') }}</label>
                                <div class="@error('numericVersion') border border-danger rounded-3 @enderror">
                                    <input id="item-numeric-version" wire:model="numericVersion" wire:change="createItemUpdated('numericVersion')" type="text" class="form-control no-padding">
                                </div>
                                @error('numericVersion')
                                <div class="text-danger">{{ $message }}</div> @enderror
                            </div>

                            <div class="mb-3">
                                <label for="item-summary">{{ __('Update summary') }}</label>
                                <div class="@error('summary') border border-danger rounded-3 @enderror">
                                    <input id="item-summary" wire:model="summary" wire:change="createItemUpdated('summary')" type="text" class="form-control no-padding">
                                </div>
                                @error('summary')
                                <div class="text-danger">{{ $message }}</div> @enderror
                            </div>

                            <div class="mb-3">
                                <label for="item-changelog">{{ __('Changelog') }}</label>
                                <div class="@error('changelog') border border-danger rounded-3 @enderror">
                                    <textarea id="item-changelog" wire:model="changelog" wire:change="createItemUpdated('changelog')" class="form-control no-padding"></textarea>
                                </div>
                                @error('changelog')
                                <div class="text-danger">{{ $message }}</div> @enderror
                            </div>

                            <div class="mb-3">
                                <label for="item-release-date">{{ __('Release Date') }}</label>
                                <div class="@error('releaseDate') border border-danger rounded-3 @enderror">
                                    <input id="item-release-date" wire:model="releaseDate" wire:change="createItemUpdated('releaseDate')" type="date" class="form-control no-padding">
                                </div>
                                @error('releaseDate')
                                <div class="text-danger">{{ $message }}</div> @enderror
                            </div>

                            <div class="mb-3">
                                <label for="item-file">{{ __('File') }}</label>
                                <div x-data="{ isUploading: false, progress: 0 }"
                                     x-on:livewire-upload-start="isUploading = true"
                                     x-on:livewire-upload-finish="isUploading = false; $wire.createItemUpdated('file')"
                                     x-on:livewire-upload-error="isUploading = false"
                                     x-on:livewire-upload-progress="progress = $event.detail.progress"
                                     class="@error('file') border border-danger rounded-3 @enderror">
                                    <input id="item-file" wire:model="file" type="file" class="form-control no-padding">

                                    <div x-show="isUploading">
                                        <progress class="w-100" max="100" x-bind:value="progress"></progress>
                                    </div>
                                </div>

                                @if(\Config::get( 'app.is_demo', false ))
                                    <div class="text-danger">{{ __( 'This action is disabled in the demo!' ) }}</div>
                                @endif

                                @error('file')
                                <div class="text-danger">{{ $message }}</div> @enderror
                            </div>

                            <div class="mb-3">
                                <label for="item-published-container">{{ __('Published') }}</label>
                                <div id="item-published-container" class="form-check form-switch ps-0">
                                    <input wire:model="published" wire:change="createItemUpdated('published')" class="form-check-input ms-auto" type="checkbox" id="published" checked="">
                                    <label class="form-check-label text-body ms-3 text-truncate w-80 mb-0" for="published">
                                        {{ __('Published') }}
                                    </label>
                                </div>
                            </div>
                        </div>
                        <div class="col-6">
                            <h5>{{ __('Access Rules') }}</h5>
                            <blockquote>
                                {{ __('Leave not-needed options empty to not use.') }}<br>
                                {{ __('All set options need to be true for the downloadable to be accessible.') }}
                            </blockquote>

                            <div class="mb-3">
                                <label for="item-assigned-after">{{ __('License Key Assigned After') }}</label>
                                <div class="@error('assignedAfter') border border-danger rounded-3 @enderror">
                                    <input id="item-assigned-after" wire:model="assignedAfter" wire:change="createItemUpdated('assignedAfter')" type="date" class="form-control no-padding">
                                </div>
                                <small class="form-text text-muted">
                                    {{ __('License keys assigned after this date') }}
                                </small>
                                @error('assignedAfter')
                                <div class="text-danger">{{ $message }}</div> @enderror
                            </div>

                            <div class="mb-3">
                                <label for="item-assigned-before">{{ __('License Key Assigned Before') }}</label>
                                <div class="@error('assignedBefore') border border-danger rounded-3 @enderror">
                                    <input id="item-assigned-before" wire:model="assignedBefore" wire:change="createItemUpdated('assignedBefore')" type="date" class="form-control no-padding">
                                </div>
                                <small class="form-text text-muted">
                                    {{ __('License keys assigned before this date') }}
                                </small>
                                @error('assignedBefore')
                                <div class="text-danger">{{ $message }}</div> @enderror
                            </div>

                            <div class="mb-3">
                                <label for="item-expires-before">{{ __('License Key Expires Before') }}</label>
                                <div class="@error('expiresBefore') border border-danger rounded-3 @enderror">
                                    <input id="item-expires-before" wire:model="expiresBefore" wire:change="createItemUpdated('expiresBefore')" type="date" class="form-control no-padding">
                                </div>
                                <small class="form-text text-muted">
                                    {{ __('License keys that will expire or expired before this date') }}
                                </small>
                                @error('expiresBefore')
                                <div class="text-danger">{{ $message }}</div> @enderror
                            </div>

                            <div class="mb-3">
                                <label for="item-accessible-until">{{ __('Accessible Until') }}</label>
                                <div class="@error('accessibleUntil') border border-danger rounded-3 @enderror">
                                    <input id="item-accessible-until" wire:model="accessibleUntil" wire:change="createItemUpdated('accessibleUntil')" type="date" class="form-control no-padding">
                                </div>
                                <small class="form-text text-muted">
                                    {{ __('The downloadable can\'t ben accessed after this date') }}
                                </small>
                                @error('accessibleUntil')
                                <div class="text-danger">{{ $message }}</div> @enderror
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button wire:click="resetInputs" type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('Close') }}</button>
                    <button id="create-item-btn" type="submit" class="btn btn-primary">{{ __('Create') }}</button>
                </div>
            </div>
        </form>
    </div>
</div>

@push('scripts')
    <script>
        window.addEventListener('open-create-modal', function (e) {
            let select = $('#products-select');
            select.select2({
                theme: 'bootstrap-5',
                dropdownParent: $('#products-select-container'),
                ajax: {
                    url: '{{ route('json-products') }}',
                    dataType: 'json',
                },
            });

            let data = select.select2("val");

            (@this()).set('productId', data);

            $('#addItemModal').modal('show');
        });

        window.addEventListener('close-create-modal', function (e) {
            $('#addItemModal').modal('hide');
        });

        $('#create-item-btn').on('click', function (e) {
            e.preventDefault();

            let data = $('#products-select').select2("val");

            (@this()).set('productId', data);
            Livewire.emit('createItem');
        });
    </script>
@endpush
