<div wire:ignore.self class="modal fade" id="updateItemModal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="updateItemModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl">
        <form wire:submit.prevent="updateItem" id="updateItemForm">
            <input wire:model="downloadableId" type="hidden">

            <div class="modal-content">
                <div class="modal-body">
                    <div class="row">
                        <div class="col-6">
                            <h5>{{ __('Update Downloadable Details') }}</h5>

                            <div id="products-select-update-container" class="mb-3" wire:ignore>
                                <label for="products-select-update" class="form-label">{{ __('Product') }}</label>
                                <div id="products-select-update-container" wire:ignore>
                                    <select id="products-select-update" class="form-select products-select"></select>
                                </div>
                            </div>

                            <div class="mb-3">
                                <label for="item-version">{{ __('Version') }}</label>
                                <div class="@error('version') border border-danger rounded-3 @enderror">
                                    <input id="item-version" wire:model="version" wire:change="updateItemUpdated('version')" type="text" class="form-control no-padding">
                                </div>
                                @error('version')
                                <div class="text-danger">{{ $message }}</div> @enderror
                            </div>

                            <div class="mb-3">
                                <label for="item-numeric-version">{{ __('Numeric Version') }}</label>
                                <div class="@error('numericVersion') border border-danger rounded-3 @enderror">
                                    <input id="item-numeric-version" wire:model="numericVersion" wire:change="updateItemUpdated('numericVersion')" type="text" class="form-control no-padding">
                                </div>
                                @error('numericVersion')
                                <div class="text-danger">{{ $message }}</div> @enderror
                            </div>

                            <div class="mb-3">
                                <label for="item-summary">{{ __('Update summary') }}</label>
                                <div class="@error('summary') border border-danger rounded-3 @enderror">
                                    <input id="item-summary" wire:model="summary" wire:change="updateItemUpdated('summary')" type="text" class="form-control no-padding">
                                </div>
                                @error('summary')
                                <div class="text-danger">{{ $message }}</div> @enderror
                            </div>

                            <div class="mb-3">
                                <label for="item-changelog">{{ __('Changelog') }}</label>
                                <div class="@error('changelog') border border-danger rounded-3 @enderror">
                                    <textarea id="item-changelog" wire:model="changelog" wire:change="updateItemUpdated('changelog')" class="form-control no-padding"></textarea>
                                </div>
                                @error('changelog')
                                <div class="text-danger">{{ $message }}</div> @enderror
                            </div>

                            <div class="mb-3">
                                <label for="item-release-date">{{ __('Release Date') }}</label>
                                <div class="@error('releaseDate') border border-danger rounded-3 @enderror">
                                    <input id="item-release-date" wire:model="releaseDate" wire:change="updateItemUpdated('releaseDate')" type="date" class="form-control no-padding">
                                </div>
                                @error('releaseDate')
                                <div class="text-danger">{{ $message }}</div> @enderror
                            </div>

                            <div class="mb-3">
                                <label for="item-file">{{ __('File') }}</label>
                                <div x-data="{ isUploading: false, progress: 0 }"
                                     x-on:livewire-upload-start="isUploading = true"
                                     x-on:livewire-upload-finish="isUploading = false; $wire.updateItemUpdated('file')"
                                     x-on:livewire-upload-error="isUploading = false"
                                     x-on:livewire-upload-progress="progress = $event.detail.progress"
                                     class="@error('file') border border-danger rounded-3 @enderror">
                                    <input id="item-file" wire:model="file" type="file" class="form-control no-padding">

                                    <div x-show="isUploading">
                                        <progress class="w-100" max="100" x-bind:value="progress"></progress>
                                    </div>
                                </div>
                                <small class="form-text text-muted">
                                    {{ __('Leave empty to keep the same file.') }}
                                </small>

                                @if(\Config::get( 'app.is_demo', false ))
                                    <div class="text-danger">{{ __( 'This action is disabled in the demo!' ) }}</div>
                                @endif

                                @error('file')
                                <div class="text-danger">{{ $message }}</div> @enderror
                            </div>

                            <div class="mb-3">
                                <label for="item-published-container">{{ __('Published') }}</label>
                                <div id="item-published-container" class="form-check form-switch ps-0">
                                    <input wire:model="published" wire:change="updateItemUpdated('published')" class="form-check-input ms-auto" type="checkbox" id="published" checked="">
                                    <label class="form-check-label text-body ms-3 text-truncate w-80 mb-0" for="published">
                                        {{ __('Published') }}
                                    </label>
                                </div>
                            </div>
                        </div>
                        <div class="col-6">
                            <h5>{{ __('Access Rules') }}</h5>
                            <blockquote>
                                {{ __('Leave not-needed options empty to not use.') }}<br>
                                {{ __('All set options need to be true for the downloadable to be accessible.') }}
                            </blockquote>

                            <div class="mb-3">
                                <label for="item-assigned-after">{{ __('License Key Assigned After') }}</label>
                                <div class="@error('assignedAfter') border border-danger rounded-3 @enderror">
                                    <input id="item-assigned-after" wire:model="assignedAfter" wire:change="updateItemUpdated('assignedAfter')" type="date" class="form-control no-padding">
                                </div>
                                <small class="form-text text-muted">
                                    {{ __('License keys assigned after this date') }}
                                </small>
                                @error('assignedAfter')
                                <div class="text-danger">{{ $message }}</div> @enderror
                            </div>

                            <div class="mb-3">
                                <label for="item-assigned-before">{{ __('License Key Assigned Before') }}</label>
                                <div class="@error('assignedBefore') border border-danger rounded-3 @enderror">
                                    <input id="item-assigned-before" wire:model="assignedBefore" wire:change="updateItemUpdated('assignedBefore')" type="date" class="form-control no-padding">
                                </div>
                                <small class="form-text text-muted">
                                    {{ __('License keys assigned before this date') }}
                                </small>
                                @error('assignedBefore')
                                <div class="text-danger">{{ $message }}</div> @enderror
                            </div>

                            <div class="mb-3">
                                <label for="item-expires-before">{{ __('License Key Expires Before') }}</label>
                                <div class="@error('expiresBefore') border border-danger rounded-3 @enderror">
                                    <input id="item-expires-before" wire:model="expiresBefore" wire:change="updateItemUpdated('expiresBefore')" type="date" class="form-control no-padding">
                                </div>
                                <small class="form-text text-muted">
                                    {{ __('License keys that will expire or expired before this date') }}
                                </small>
                                @error('expiresBefore')
                                <div class="text-danger">{{ $message }}</div> @enderror
                            </div>

                            <div class="mb-3">
                                <label for="item-accessible-until">{{ __('Accessible Until') }}</label>
                                <div class="@error('accessibleUntil') border border-danger rounded-3 @enderror">
                                    <input id="item-accessible-until" wire:model="accessibleUntil" wire:change="updateItemUpdated('accessibleUntil')" type="date" class="form-control no-padding">
                                </div>
                                <small class="form-text text-muted">
                                    {{ __('The downloadable can\'t ben accessed after this date') }}
                                </small>
                                @error('accessibleUntil')
                                <div class="text-danger">{{ $message }}</div> @enderror
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button wire:click="resetInputs" type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('Close') }}</button>
                    <button id="update-item-btn" type="submit" class="btn btn-primary">{{ __('Update') }}</button>
                </div>
            </div>
        </form>
    </div>
</div>

@push('scripts')
    <script>
        window.addEventListener('open-update-modal', function (e) {
            const $select2 = $('#products-select-update');

            $select2.html('<option value="' + e.detail.productId + '">' + e.detail.productName + '</option>')

            $select2.select2({
                theme: 'bootstrap-5',
                dropdownParent: $('#products-select-update-container'),
                ajax: {
                    url: '{{ route('json-products') }}',
                    dataType: 'json',
                },
            });

            (@this()).set('productId', e.detail.productId);

            $('#updateItemModal').modal('show');
        });

        window.addEventListener('close-update-modal', function (e) {
            $('#updateItemModal').modal('hide');
        });

        $('#update-item-btn').on('click', function (e) {
            e.preventDefault();

            let data = $('#products-select-update').select2("val");

            (@this()).set('productId', data);
            Livewire.emit('updateItem');
        });
    </script>
@endpush
