<div wire:ignore.self class="modal fade" id="updateItemModal" data-bs-backdrop="static" data-bs-keyboard="false" aria-labelledby="updateItemModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <form wire:submit.prevent="updateItem" id="updateItemModalLabel">
            <input wire:model="updateId" type="hidden">

            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="staticBackdropLabel">{{ __('Create Generate') }}</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body" x-data="{ methodSelected: @entangle('method') }">
                    <div class="mb-3">
                        <label for="products-select-update" class="form-label">{{ __('Product') }}</label>
                        <div id="products-select-update-container" wire:ignore>
                            <select id="products-select-update" class="form-select products-select"></select>
                        </div>
                        @error('productId')
                        <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="method" class="form-label">{{ __('Method') }}</label>
                        <select x-on:change="methodSelected = $event.target.value"
                                id="method" class="form-select
                                @error('method') border border-danger rounded-3 @enderror"
                                wire:model="method"
                                wire:change="updateItemUpdated('method')"
                        >
                            <option value="">{{ __('Select Method') }}</option>
                            <option value="uuid">{{ __('UUID') }}</option>
                            <option value="chunk-system">{{ __('Chunk System') }}</option>
                            <option value="custom">{{ __('Custom Function') }}</option>
                        </select>

                        @error('method')
                        <div class="text-danger">{{ $message }}</div> @enderror
                    </div>

                    <div x-show="methodSelected == 'custom'">
                        <div class="mb-3">
                            <label for="functionName">{{ __('Function Name') }}</label>
                            <div class="@error('functionName') border border-danger rounded-3 @enderror">
                                <input id="functionName" wire:model="functionName" wire:change="updateItemUpdated('functionName')" type="text" class="form-control no-padding">
                            </div>
                            @error('functionName')
                            <div class="text-danger">{{ $message }}</div> @enderror
                        </div>
                    </div>

                    <div x-show="methodSelected == 'chunk-system'">
                        <div class="mb-3">
                            <label for="numberOfChunks">{{ __('Number Of Chunks') }}</label>
                            <div class="@error('numberOfChunks') border border-danger rounded-3 @enderror">
                                <input id="numberOfChunks" wire:model="numberOfChunks" wire:change="updateItemUpdated('numberOfChunks')" type="number" class="form-control no-padding">
                            </div>
                            @error('numberOfChunks')
                            <div class="text-danger">{{ $message }}</div> @enderror
                        </div>

                        <div class="mb-3">
                            <label for="chunkLength">{{ __('Chunk Length') }}</label>
                            <div class="@error('chunkLength') border border-danger rounded-3 @enderror">
                                <input id="chunkLength" wire:model="chunkLength" wire:change="updateItemUpdated('chunkLength')" type="number" class="form-control no-padding">
                            </div>
                            @error('chunkLength')
                            <div class="text-danger">{{ $message }}</div> @enderror
                        </div>

                        <div class="mb-3">
                            <label for="charset">{{ __('Charset') }}</label>
                            <div class="@error('charset') border border-danger rounded-3 @enderror">
                                <input id="charset" wire:model="charset" wire:change="updateItemUpdated('charset')" type="text" class="form-control no-padding">
                            </div>
                            @error('charset')
                            <div class="text-danger">{{ $message }}</div> @enderror
                        </div>
                    </div>

                    <div class="mb-3">
                        <label for="prefix">{{ __('Prefix') }}</label>
                        <div class="@error('prefix') border border-danger rounded-3 @enderror">
                            <input id="prefix" wire:model="prefix" wire:change="updateItemUpdated('prefix')" type="text" class="form-control no-padding">
                        </div>
                        @error('prefix')
                        <div class="text-danger">{{ $message }}</div> @enderror
                    </div>

                    <div class="mb-3">
                        <label for="suffix">{{ __('Suffix') }}</label>
                        <div class="@error('suffix') border border-danger rounded-3 @enderror">
                            <input id="suffix" wire:model="suffix" wire:change="updateItemUpdated('suffix')" type="text" class="form-control no-padding">
                        </div>
                        @error('suffix')
                        <div class="text-danger">{{ $message }}</div> @enderror
                    </div>

                    <div class="mb-3">
                        <label for="activation-limit-input">{{ __('Activation Limit') }}</label>
                        <div class="@error('activationLimit') border border-danger rounded-3 @enderror">
                            <input id="activation-limit-input" wire:model="activationLimit" wire:change="updateItemUpdated('activationLimit')" type="number" class="form-control no-padding">
                        </div>
                        @error('activationLimit')
                        <div class="text-danger">{{ $message }}</div> @enderror
                    </div>

                    <div class="mb-3">
                        <label for="validity-input">{{ __('Validity (days)') }}</label>
                        <div class="@error('validity') border border-danger rounded-3 @enderror">
                            <input id="validity-input" wire:model="validity" wire:change="updateItemUpdated('validity')" type="number" class="form-control no-padding">
                        </div>
                        @error('validity')
                        <div class="text-danger">{{ $message }}</div> @enderror
                    </div>

                    <div class="mb-3">
                        <label for="validity-input">{{ __('Status') }}</label>
                        <div class="form-check form-switch ps-0">
                            <input wire:model="status" wire:change="updateItemUpdated('status')" class="form-check-input ms-auto" type="checkbox" id="status" checked="">
                            <label class="form-check-label text-body ms-3 text-truncate w-80 mb-0" for="status">
                                {{ __('Generator Active') }}
                            </label>

                            @error('status')
                            <div class="text-danger">{{ $message }}</div> @enderror
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button wire:click="resetInputs" type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('Close') }}</button>
                    <button id="create-btn" type="submit" class="btn btn-primary">{{ __('Update') }}</button>
                </div>
            </div>
        </form>
    </div>
</div>

@push('scripts')
    <script>
        window.addEventListener('open-update-modal', function (e) {
            const $select2 = $('#products-select-update');

            $select2.html('<option value="' + e.detail.productId + '">' + e.detail.productName + '</option>')

            $select2.select2({
                theme: 'bootstrap-5',
                dropdownParent: $('#products-select-update-container'),
                ajax: {
                    url: '{{ route('json-products') }}',
                    dataType: 'json',
                },
            });

            (@this()).set('productId', e.detail.productId);

            $('#updateItemModal').modal('show');
        });

        window.addEventListener('close-update-modal', function (e) {
            $('#updateItemModal').modal('hide');
        });

        $('#update-item-btn').on('click', function (e) {
            e.preventDefault();

            let data = $('#products-select-update').select2("val");

            (@this()).set('productId', data);
            Livewire.emit('updateItem');
        });
    </script>
@endpush
