@section('page-title')
    {{ __('License Keys') }}
@endsection

@section('breadcrumbs')
    <li class="breadcrumb-item text-md">
        <a class="opacity-5 text-dark" href="{{ route('license-keys') }}">
            {{ __('License Keys') }}
        </a>
    </li>

    <li class="breadcrumb-item text-sm text-dark active text-capitalize" aria-current="page">
        {{ __('Management') }}
    </li>
@endsection

<div>
    <div class="row">
        <div class="col-12">
            <div class="card mb-4 mx-4">
                <ul class="list-group list-group-flush" x-data="{ showFilterOptions: false, showBulkOptions: false }">
                    <li class="list-group-item">
                        <div class="float-start">
                            <h5 class="card-title m-0">
                                @yield('page-title')
                            </h5>
                        </div>
                        <div class="float-end">
                            <a wire:click="openImportModal" href="#" class="btn btn-action mb-0">
                                    <span class="btn-inner--icon me-1">
                                        <i class="fas fa-file-import"></i>
                                    </span>
                                <span class="btn-inner--text">{{ __('Import') }}</span>
                            </a>

                            <a wire:click="openCreateModal" href="#" class="btn btn-action mb-0">
                                    <span class="btn-inner--icon me-1">
                                        <i class="fas fa-plus-circle"></i>
                                    </span>
                                <span class="btn-inner--text">{{ __('Create') }}</span>
                            </a
                        </div>
                    </li>
                    <li class="list-group-item">
                        <a href="#" class="btn btn-action mb-0" x-on:click="showBulkOptions = !showBulkOptions">
                            <span x-show="!showBulkOptions" class="btn-inner--text">{{ __('Bulk Actions') }}</span>
                            <span x-show="showBulkOptions" class="btn-inner--text">{{ __('Hide Bulk Actions') }}</span>
                        </a>
                        <a href="#" class="btn btn-action mb-0" x-on:click="showFilterOptions = !showFilterOptions">
                            <span x-show="!showFilterOptions" class="btn-inner--text"><i class="fas fa-filter"></i></span>
                            <span x-show="showFilterOptions" class="btn-inner--text">{{ __('Hide Filters') }}</span>
                        </a>
                    </li>

                    <li class="list-group-item" x-show="showFilterOptions">
                        <form class="form-inline">
                            <input id="filter-license-key" type="text" placeholder="{{ __('License Key') }}" class="form-control form-control-sm">
                            <input id="filter-owner-name" type="text" placeholder="{{ __('Owner Name') }}" class="form-control form-control-sm">
                            <input id="filter-owner-email" type="text" placeholder="{{ __('Owner Email') }}" class="form-control form-control-sm">
                            <div class="select-container" wire:ignore>
                                <select id="filter-product-id" class="form-control form-control-sm m-0">
                                    <option selected>{{ __('Product') }}</option>
                                </select>
                            </div>
                            <select id="filter-status" class="form-select form-select-sm">
                                <option selected>{{ __('Status') }}</option>
                                @foreach($statuses as $key => $value)
                                    <option value="{{ $key }}">{{ $value['text'] }}</option>
                                @endforeach
                            </select>

                            <button x-on:click="filterItems()" id="filer-submit" type="button" class="btn btn-action-apply me-2">
                                <span class="btn-inner--text">{{ __('Apply') }}</span>
                            </button>

                            <button x-on:click="filterReset()" type="reset" class="btn btn-action-apply btn-action-danger">
                                <span class="btn-inner--text">{{ __('Reset') }}</span>
                            </button>
                        </form>
                    </li>

                    <li class="list-group-item" x-show="showBulkOptions">
                        <form class="form-inline" wire:submit.prevent="bulkActions">
                            <button x-on:click="bulkDelete()" type="button" class="btn btn-action-apply btn-action-danger me-2">
                                <span class="btn-inner--text">{{ __('Delete') }}</span>
                            </button>

                            <select id="bulk-change-status" x-on:change="bulkChangeStatus()" class="form-control form-control-sm x-fit-content">
                                <option value="" selected>{{ __('Change Status') }}</option>
                                @foreach($statuses as $key => $value)
                                    <option value="{{ $key }}">{{ __('Change status to: ') }} {{ $value['text'] }}</option>
                                @endforeach
                            </select>
                        </form>
                    </li>

                    <li class="list-group-item p-0"></li>
                </ul>

                <div class="card-body px-0 pt-0 pb-2">
                    <div class="table-responsive p-0">
                        <table class="table align-items-center mb-0">
                            <thead>
                            <tr>
                                <th class="text-xxs opacity-7">
                                    <input type="checkbox" id="bulk-action-checkbox">
                                </th>
                                <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                    {{ __('ID') }}
                                </th>
                                <th class="text-secondary text-uppercase  text-xxs font-weight-bolder opacity-7 ps-2">
                                    {{ __('License Key') }}
                                </th>
                                <th class="text-secondary text-uppercase  text-xxs font-weight-bolder opacity-7 ps-2">
                                    {{ __('Owner Name') }}
                                </th>
                                <th class="text-secondary text-uppercase  text-xxs font-weight-bolder opacity-7 ps-2">
                                    {{ __('Email') }}
                                </th>
                                <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                    {{ __('Product') }}
                                </th>
                                <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                    {{ __('Activation Limit') }}
                                </th>
                                <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                    {{ __('Creation Date') }}
                                </th>
                                <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                    {{ __('Assign Date') }}
                                </th>
                                <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                    {{ __('Expiration Date') }}
                                </th>
                                <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                    {{ __('Status') }}
                                </th>
                                <th class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                    {{ __('Action') }}
                                </th>
                            </tr>
                            </thead>
                            <tbody>

                            @if($licenseKeys->count() > 0)
                                @foreach($licenseKeys as $licenseKey)
                                    <tr>
                                        <td class="ps-4">
                                            <p class="text-xs font-weight-bold mb-0">
                                                <input type="checkbox" class="bulk-action-checkbox" value="{{ $licenseKey->id }}">
                                            </p>
                                        </td>
                                        <td class="ps-4">
                                            <p class="text-xs font-weight-bold mb-0">{{ $licenseKey->id }}</p>
                                        </td>
                                        <td class="text-start">
                                            <p class="text-xs font-weight-bold mb-0">{{ $licenseKey->license_key }}</p>
                                        </td>

                                        <td class="text-start">
                                            <p class="text-xs font-weight-bold mb-0">{{ $licenseKey->owner_name != '' ? $licenseKey->owner_name : '-' }}</p>
                                        </td>

                                        <td class="text-start">
                                            <p class="text-xs font-weight-bold mb-0">{{ $licenseKey->owner_email != '' ? $licenseKey->owner_email : '-' }}</p>
                                        </td>

                                        <td class="text-start">
                                            <p class="text-xs font-weight-bold mb-0">
                                                @if(isset($licenseKey->product))
                                                    #{{ $licenseKey->product_id }} {{ $licenseKey->product->name }}
                                                @else
                                                    <span class="badge badge-sm bg-danger">{{ sprintf( __( 'Product Not Found #%d' ), $licenseKey->product_id ) }}</span>
                                                @endif
                                            </p>
                                        </td>

                                        <td class="text-start">
                                            <p class="text-xs font-weight-bold mb-0">{{ $licenseKey->activation_limit ? $licenseKey->activation_limit : '-' }}</p>
                                        </td>
                                        <td class="text-start">
                                            <span class="text-secondary text-xs font-weight-bold">{{ formatDatetime($licenseKey->created_at) }}</span>
                                        </td>
                                        <td class="text-start">
                                            <span class="text-secondary text-xs font-weight-bold">{{ $licenseKey->assigned_at ? formatDatetime($licenseKey->assigned_at) : '-' }}</span>
                                        </td>
                                        <td class="text-start">
                                            <span class="text-secondary text-xs font-weight-bold">{{ $licenseKey->getExpiration() ? formatDatetime($licenseKey->getExpiration()) : '-' }}</span>
                                        </td>
                                        <td class="text-start">
                                                <span class="text-capitalize text-up text-secondary text-xs font-weight-bold">
                                                    <span class="badge badge-sm" style="background: {{ $statuses[ $licenseKey->status ]['color'] }}">{{ $statuses[ $licenseKey->status ]['text'] }}</span>
                                                </span>
                                        </td>
                                        <td class="text-center text-sm" x-data>
                                            <a wire:click="openUpdateModal({{ $licenseKey->id }})" href="#" class="me-3">
                                                <i class="cursor-pointer fas fa-edit text-secondary"></i>
                                            </a>

                                            <a x-on:click="openDeleteModal({{ $licenseKey->id }})" href="#">
                                                <i class="cursor-pointer fas fa-trash text-secondary"></i>
                                            </a>
                                        </td>
                                    </tr>
                                @endforeach
                            @else
                                <tr>
                                    <td class="ps-4" colspan="10">
                                        <p class="text-center text-secondary text-xs font-weight-bold mb-0">{{ __('No license keys found') }}</p>
                                    </td>
                                </tr>
                            @endif
                            </tbody>
                        </table>
                    </div>
                </div>

                {{ $licenseKeys->links() }}
            </div>
        </div>
    </div>

    @include('livewire.license-keys.modal-import-items')
    @include('livewire.license-keys.modal-add-item')
    @include('common.modal-delete-item', [
	    'name'    => 'license key',
	    'warning' => __('All the activations and metadata associated with this license key will be deleted too.')
    ])
    @include('livewire.license-keys.modal-update-item')
    @include('common.confirm-bulk-action')
</div>

@push('scripts')
    <script>
        window.addEventListener('filter-done', function (e) {
            let select = $('#filter-product-id');
            select.select2({
                ajax: {
                    url: '{{ route('json-products') }}?includeNoneOption=1',
                    dataType: 'json',
                },
            });
        });

        $(document).ready(function () {
            let select = $('#filter-product-id');
            select.select2({
                ajax: {
                    url: '{{ route('json-products') }}?includeNoneOption=1',
                    dataType: 'json',
                },
            });
        });

        function filterItems() {
            (@this()).set('filterLicenseKey', $('#filter-license-key').val());
            (@this()).set('filterOwnerName', $('#filter-owner-name').val());
            (@this()).set('filterOwnerEmail', $('#filter-owner-email').val());
            (@this()).set('filterProductId', $('#filter-product-id').select2("val"));
            (@this()).set('filterStatus', $('#filter-status').val());

            Livewire.emit('filterItems');
        }

        function filterReset() {
            (@this()).set('filterLicenseKey', '');
            (@this()).set('filterOwnerName', '');
            (@this()).set('filterOwnerEmail', '');
            (@this()).set('filterProductId', '');
            (@this()).set('filterStatus', '');
            Livewire.emit('filterItems')
        }
    </script>
@endpush
