<div wire:ignore.self class="modal fade" id="updateItemModal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="updateItemModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <form wire:submit.prevent="updateItem" id="updateItemForm">
            <input wire:model="productId" type="hidden">

            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="staticBackdropLabel">{{ __('Update Product') }}</h5>
                </div>
                <div class="modal-body" x-data="{ showExternalReference:false }">
                    <div class="mb-3">
                        <label for="source" class="form-label">{{ __('Source') }}</label>
                        <select x-on:change="showExternalReference = $event.target.value != 'internal' && $event.target.value != ''"
                                id="source"
                                class="form-select @error('source') border border-danger rounded-3 @enderror"
                                wire:model="source"
                                wire:change="updateItemUpdated('source')"
                        >
                            <option value="">{{ __('Select Status') }}</option>
                            <option value="internal">{{ __('Internal') }}</option>
                            <option value="envato">{{ __('Envato') }}</option>
                        </select>

                        @error('source')
                        <div class="text-danger">{{ $message }}</div> @enderror
                    </div>

                    <div x-show="showExternalReference" class="mb-3">
                        <label for="product-ref">{{ __('External Reference') }}</label>
                        <div class="@error('externalReference') border border-danger rounded-3 @enderror">
                            <input id="product-ref" wire:model="externalReference" wire:change="updateItemUpdated('externalReference')" type="text" class="form-control no-padding">
                        </div>
                        @error('externalReference')
                        <div class="text-danger">{{ $message }}</div> @enderror
                    </div>

                    <div class="mb-3">
                        <label for="product-name">{{ __('Name') }}</label>
                        <div class="@error('name') border border-danger rounded-3 @enderror">
                            <input id="product-name" wire:model="name" wire:change="updateItemUpdated('name')" type="text" class="form-control no-padding">
                        </div>
                        @error('name')
                        <div class="text-danger">{{ $message }}</div> @enderror
                    </div>

                    <div class="mb-3">
                        <label for="product-description">{{ __('Description') }}</label>
                        <div class="@error('description') border border-danger rounded-3 @enderror">
                            <textarea id="product-description" wire:model="description" wire:change="updateItemUpdated('description')" class="form-control no-padding"></textarea>
                        </div>
                        @error('description')
                        <div class="text-danger">{{ $message }}</div> @enderror
                    </div>

                    <div class="form-check form-switch ps-0">
                        <input wire:model="requireNonExpired" wire:change="updateItemUpdated('requireNonExpired')" class="form-check-input ms-auto" type="checkbox" id="requireNonExpired" checked="">
                        <label class="form-check-label text-body ms-3 text-truncate w-80 mb-0" for="requireNonExpired">
                            {{ __('Require non-expired license key to access downloadable') }}
                        </label>

                        @error('requireNonExpired')
                        <div class="text-danger">{{ $message }}</div> @enderror
                    </div>

                    <div class="mb-3">
                        <label for="status" class="form-label">{{ __('Status') }}</label>
                        <select id="status" class="form-select @error('status') border border-danger rounded-3 @enderror" wire:model="status" wire:change="updateItemUpdated('status')">
                            <option value="">{{ __('Select Status') }}</option>
                            <option value="active">{{ __('Active') }}</option>
                            <option value="inactive">{{ __('Inactive') }}</option>
                        </select>

                        @error('status')
                        <div class="text-danger">{{ $message }}</div> @enderror
                    </div>

                    <div class="mb-3">
                        <label for="settings-api-passphrase">{{ __('Passphrase') }}</label>
                        <div class="@error('passphrase') border border-danger rounded-3 @enderror">
                            <input id="settings-api-passphrase" wire:model="passphrase" wire:change="updateItemUpdated('passphrase')" type="text" class="form-control no-padding">
                        </div>
                        @error('passphrase')
                        <div class="text-danger">{{ $message }}</div> @enderror
                    </div>

                    <div class="mb-3">
                        <label for="settings-api-private">{{ __('Private Key') }}</label>
                        <div class="@error('privateKey') border border-danger rounded-3 @enderror">
                            <textarea id="settings-api-private"
                                      wire:model="privateKey"
                                      wire:change="updateItemUpdated('privateKey')"
                                      type="text"
                                      class="form-control no-padding"></textarea>
                        </div>
                        @error('privateKey')
                        <div class="text-danger">{{ $message }}</div> @enderror
                    </div>

                    <div class="mb-3">
                        <label for="algorithm" class="form-label">{{ __('Algorithm') }}</label>
                        <select id="algorithm" class="form-select @error('algorithm') border border-danger rounded-3 @enderror" wire:model="algorithm" wire:change="updateItemUpdated('algorithm')">
                            <option value="">{{ __('Select Algorithm') }}</option>
                            <option value="1">{{ __('SHA1') }}</option>
                            <option value="2">{{ __('MD5') }}</option>
                            <option value="3">{{ __('MD4') }}</option>
                            <option value="6">{{ __('SHA224') }}</option>
                            <option value="7">{{ __('SHA256') }}</option>
                            <option value="8">{{ __('SHA384') }}</option>
                            <option value="9">{{ __('SHA512') }}</option>
                            <option value="10">{{ __('RMD160') }}</option>
                        </select>

                        @error('algorithm')
                        <div class="text-danger">{{ $message }}</div> @enderror
                    </div>

                </div>
                <div class="modal-footer">
                    <button wire:click="resetInputs" type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('Close') }}</button>
                    <button id="update-item-btn" type="submit" class="btn btn-primary">{{ __('Update') }}</button>
                </div>
            </div>
        </form>
    </div>
</div>


@push('scripts')
    <script>
        window.addEventListener('open-update-modal', function (e) {
            $('#updateItemModal').modal('show');
        });

        window.addEventListener('close-update-modal', function (e) {
            $('#updateItemModal').modal('hide');
        });

        $('#update-item-btn').on('click', function (e) {
            e.preventDefault();

            Livewire.emit('updateItem');
        });
    </script>
@endpush
