@section('page-title')
    {{ __('Users') }}
@endsection

@section('breadcrumbs')
    <li class="breadcrumb-item text-md">
        <a class="opacity-5 text-dark" href="{{ route('users') }}">
            {{ __('Users') }}
        </a>
    </li>

    <li class="breadcrumb-item text-sm text-dark active text-capitalize" aria-current="page">
        {{ __('Management') }}
    </li>
@endsection

<div class="row">
    <div class="col-12">
        <div class="card mb-4 mx-4">
            <ul class="list-group list-group-flush" x-data="{ showFilterOptions: false }">
                <li class="list-group-item">
                    <div class="float-start">
                        <h5 class="card-title m-0">
                            @yield('page-title')
                        </h5>
                    </div>
                    <div class="float-end">
                        <a wire:click="openCreateModal" href="#" class="btn btn-action mb-0">
                                    <span class="btn-inner--icon me-1">
                                        <i class="fas fa-plus-circle"></i>
                                    </span>
                            <span class="btn-inner--text">{{ __('Add') }} @yield('page-title')</span>
                        </a>
                    </div>
                </li>
                <li class="list-group-item">
                    <a href="#" class="btn btn-action mb-0" x-on:click="showFilterOptions = !showFilterOptions">
                        <span x-show="!showFilterOptions" class="btn-inner--text"><i class="fas fa-filter"></i></span>
                        <span x-show="showFilterOptions" class="btn-inner--text">{{ __('Hide Filters') }}</span>
                    </a>
                </li>

                <li class="list-group-item" x-show="showFilterOptions">
                    @include('common.filter-search')
                </li>

                <li class="list-group-item p-0"></li>
            </ul>
            <div class="card-body px-0 pt-0 pb-2">
                <div class="table-responsive p-0">
                    <table class="table align-items-center mb-0">
                        <thead>
                        <tr>
                            <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                ID
                            </th>
                            <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                Photo
                            </th>
                            <th class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                Name
                            </th>
                            <th class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                Email
                            </th>
                            <th class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                role
                            </th>
                            <th class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                Creation Date
                            </th>
                            <th class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                Action
                            </th>
                        </tr>
                        </thead>
                        <tbody>

                        @if($users->count() > 0)
                            @foreach($users as $user)
                                <tr>
                                    <td class="ps-4">
                                        <p class="text-xs font-weight-bold mb-0">{{ $user->id }}</p>
                                    </td>
                                    <td>
                                        <div>
                                            <img src="https://www.gravatar.com/avatar/{{ md5( strtolower( trim( $user->email ) ) ) }}" class="avatar avatar-sm me-3">
                                        </div>
                                    </td>
                                    <td class="text-center">
                                        <p class="text-xs font-weight-bold mb-0">{{ $user->name }}</p>
                                    </td>
                                    <td class="text-center">
                                        <p class="text-xs font-weight-bold mb-0">{{ $user->email }}</p>
                                    </td>
                                    <td class="text-center">
                                        <p class="text-xs font-weight-bold mb-0">{{ $user->getFormattedRole() }}</p>
                                    </td>
                                    <td class="text-center">
                                        <span class="text-secondary text-xs font-weight-bold">{{ formatDatetime($user->created_at) }}</span>
                                    </td>
                                    <td class="text-center text-sm" x-data>
                                        <a wire:click="openUpdateModal({{ $user->id }})" href="#" class="mx-3">
                                            <i class="fas fa-user-edit text-secondary"></i>
                                        </a>

                                        @if ( Auth::id() != $user->id )
                                            <a x-on:click="openDeleteModal({{ $user->id }})" href="#">
                                                <i class="cursor-pointer fas fa-trash text-secondary"></i>
                                            </a>
                                        @endif
                                    </td>
                                </tr>
                            @endforeach
                        @else
                            <tr>
                                <td class="ps-4" colspan="7">
                                    <p class="text-center text-secondary text-xs font-weight-bold mb-0">{{ __('No users found') }}</p>
                                </td>
                            </tr>
                        @endif
                        </tbody>
                    </table>
                </div>
            </div>

            {{ $users->links() }}
        </div>
    </div>

    @include('livewire.users.modal-add-item')
    @include('livewire.users.modal-update-item')
    @include('common.modal-delete-item',  ['name' => 'delete'])
</div>
