<?php

use App\Http\Controllers\Api\V1\ApiController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::prefix( 'v1' )->middleware( [ 'api_access_restrictions', 'api_key' ] )->group( function () {
	Route::post( '/verify', [ ApiController::class, 'verify' ] )->name( 'verify' );
	Route::post( '/activate', [ ApiController::class, 'activate' ] )->name( 'activate' );
	Route::post( '/deactivate', [ ApiController::class, 'deactivate' ] )->name( 'deactivate' );
	Route::post( '/get-license-key-details', [ ApiController::class, 'getLicenseKeyDetails' ] )->name( 'get-license-key-details' );
	Route::post( '/access-downloadables', [ ApiController::class, 'accessDownloadables' ] )->name( 'access-downloadables' );
	Route::get( '/download/{api_key}/{license_key}/{identifier}/{version}', [ ApiController::class, 'download' ] )->name( 'access-downloadables.download' );

	Route::post( '/assign-license-key', [ ApiController::class, 'assignLicenseKey' ] )->name( 'assign-license-key' );

	Route::post( '/assign-and-activate-license-key', [ ApiController::class, 'assignAndActivateLicenseKey' ] )->name( 'assign-and-activate-license-key' );

	Route::post( '/create-license-keys', [ ApiController::class, 'createLicenseKey' ] )->name( 'create-license-key' );
	Route::post( '/create-license-key-meta', [ ApiController::class, 'createLicenseKeyMeta' ] )->name( 'create-license-key-meta' );
	Route::post( '/create-product', [ ApiController::class, 'createProduct' ] )->name( 'create-product' );
	Route::post( '/create-product-meta', [ ApiController::class, 'createProductMeta' ] )->name( 'create-product-meta' );

	Route::post( '/update-license-key', [ ApiController::class, 'updateLicenseKey' ] )->name( 'update-license-key' );
	Route::post( '/update-license-key-meta', [ ApiController::class, 'updateLicenseKeyMeta' ] )->name( 'update-license-key-meta' );
	Route::post( '/update-product', [ ApiController::class, 'updateProduct' ] )->name( 'update-product' );
	Route::post( '/update-product-meta', [ ApiController::class, 'updateProductMeta' ] )->name( 'update-product-meta' );

	Route::post( '/delete-license-key', [ ApiController::class, 'deleteLicenseKey' ] )->name( 'delete-license-key' );
	Route::post( '/delete-license-key-meta', [ ApiController::class, 'deleteLicenseKeyMeta' ] )->name( 'delete-license-key-meta' );
	Route::post( '/delete-product', [ ApiController::class, 'deleteProduct' ] )->name( 'delete-product' );
	Route::post( '/delete-product-meta', [ ApiController::class, 'deleteProductMeta' ] )->name( 'delete-product-meta' );

	Route::get( '/get-all-products', [ ApiController::class, 'getProducts' ] )->name( 'get-all-products' );
	Route::get( '/get-license-keys', [ ApiController::class, 'getLicenseKeys' ] )->name( 'get-license-keys' );
	Route::get( '/get-all-generators', [ ApiController::class, 'getGenerators' ] )->name( 'get-all-generators' );
	Route::post( '/generate', [ ApiController::class, 'generate' ] )->name( 'generate' );

	Route::post( '/send-telemetry-date', [ ApiController::class, 'sendTelemetryData' ] )->name( 'send-telemetry-data' );
	Route::get( '/get-telemetry-date', [ ApiController::class, 'getTelemetryData' ] )->name( 'get-telemetry-data' );

	Route::get( '/get-available-license-keys-count', [ ApiController::class, 'getAvailableLicenseKeysCount' ] )->name( 'get-available-license-keys-count' );
} );
