<?php

use App\Http\Controllers\Installer\DatabaseController;
use App\Http\Controllers\Installer\PurchaseCodeController;
use App\Http\Controllers\JsonController;
use App\Http\Livewire\Activations;
use App\Http\Livewire\ApiKeys;
use App\Http\Livewire\Auth\Login;
use App\Http\Livewire\Dashboard;
use App\Http\Livewire\Downloadables;
use App\Http\Livewire\Generators;
use App\Http\Livewire\LicenseKeys;
use App\Http\Livewire\Logs;
use App\Http\Livewire\Products;
use App\Http\Livewire\Settings;
use App\Http\Livewire\Telemetry;
use App\Http\Livewire\Users;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get( '/', function () {
	return redirect( '/login' );
} );

Route::middleware( [ 'is_installed' ] )->group( function () {
	Route::get( '/login', Login::class )->name( 'login' );
} );

if ( file_exists( storage_path( 'installed' ) ) ) {
	Route::middleware( [ 'auth', 'user_can' ] )->group( function () {
		Route::get( '/dashboard', Dashboard::class )->name( 'dashboard' );
		Route::get( '/users', Users::class )->name( 'users' );
		Route::get( '/license-keys', LicenseKeys::class )->name( 'license-keys' );
		Route::get( '/generators', Generators::class )->name( 'generators' );
		Route::get( '/products', Products::class )->name( 'products' );
		Route::get( '/downloadables', Downloadables::class )->name( 'downloadables' );
		Route::get( '/activations', Activations::class )->name( 'activations' );
		Route::get( '/api-keys', ApiKeys::class )->name( 'api-keys' );
		Route::get( '/settings', Settings::class )->name( 'settings' );
		Route::get( '/logs', Logs::class )->name( 'logs' );
		Route::get( '/telemetry', Telemetry::class )->name( 'telemetry' );

		Route::get( 'json/products', [ JsonController::class, 'getProducts' ] )->name( 'json-products' );
	} );
}

Route::group( [ 'prefix' => 'install', 'as' => 'LaravelInstaller::', 'middleware' => [ 'web', 'install' ] ], function () {
	Route::get( 'purchase-code', [ PurchaseCodeController::class, 'purchaseCode' ] )->name( 'purchaseCode' );
	Route::get( 'purchase-code/save', [ PurchaseCodeController::class, 'purchaseCodeSave' ] )->name( 'purchaseCodeSave' );

	Route::get( 'setup-database', [ DatabaseController::class, 'database' ] )->name( 'setupDatabase' );
} );
